-- 1.6.0 Changes

-- We will include language strings table here itself for quick fix.
-- This should be supported by its component installer itself
CREATE TABLE IF NOT EXISTS `#__languages_strings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_constant` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orig_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `client` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sellacious_product_questions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variant_id` int(11) NOT NULL,
  `seller_uid` int(11) NOT NULL,
  `questioner_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `questioner_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` int(11) NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL,
  `replied` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `replied_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sellacious_associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `assoc_key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sellacious_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_code` varchar(7) NOT NULL,
  `reference_id` int(11) NOT NULL,
  `reference_table` varchar(100) NOT NULL,
  `reference_field` varchar(100) NOT NULL,
  `value` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sellacious_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `handler` varchar(255) NOT NULL,
  `columns` text NOT NULL,
  `filter` text NOT NULL,
  `state` int(11) NOT NULL DEFAULT '1',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sellacious_reports_permissions` (
  `report_id` int(11) NOT NULL,
  `user_cat_id` int(11) NOT NULL,
  `permission_type` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__sellacious_product_buttons` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL DEFAULT '',
  `params` TEXT NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE = InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__sellacious_emailtemplates` (`id`, `subject`, `body`, `recipients`, `sender`, `cc`, `bcc`, `replyto`, `send_actual_recipient`, `context`, `recipient_category`, `state`, `created`, `created_by`, `modified`, `modified_by`, `params`) VALUES
(NULL, '%SITENAME% | New Question from %SENDER_NAME%', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 80px 0 20px;\"><a href=\"http://sellacious.com/\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello Admin,</h2>\r\n<h2 style=\"font-size: 18px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">You have a new question from %SENDER_NAME% for the product <a href=\"%PRODUCT_URL%\" target=\"_blank\" rel=\"noopener noreferrer\">%PRODUCT_NAME%</a>.</h2>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0 10px; text-align: justify;\"><b>Q: %QUESTION%</b></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<p style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #676d76; margin: 10px 0 0; padding: 20px 0; text-align: center; background-color: #d3ebff;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'question.admin', 0, 1, '2018-04-02 00:16:41', 78, '2018-04-02 05:05:10', 78, ''),
(NULL, '%SITENAME% | New Question from %SENDER_NAME%', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 80px 0 20px;\"><a href=\"http://sellacious.com/\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello %SELLER_COMPANY%,</h2>\r\n<h2 style=\"font-size: 18px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">You have a new question from %SENDER_NAME% for the product <a href=\"%PRODUCT_URL%\" target=\"_blank\" rel=\"noopener noreferrer\">%PRODUCT_NAME%</a>.</h2>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0 10px; text-align: justify;\"><b>Q: %QUESTION%</b></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<p style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #676d76; margin: 10px 0 0; padding: 20px 0; text-align: center; background-color: #d3ebff;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'question.seller', 0, 1, '2018-04-02 00:20:00', 78, '2018-04-02 05:04:47', 78, ''),
(NULL, '%SITENAME% | Thanks for Question', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 80px 0 20px;\"><a href=\"http://sellacious.com/\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello %SENDER_NAME%,</h2>\r\n<h2 style=\"font-size: 18px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Thanks for asking the question for the product <a href=\"%PRODUCT_URL%\" target=\"_blank\" rel=\"noopener noreferrer\">%PRODUCT_NAME%</a>. We will reply soon.</h2>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0 10px; text-align: justify;\"><b>Q: %QUESTION%</b></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<p style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #676d76; margin: 10px 0 0; padding: 20px 0; text-align: center; background-color: #d3ebff;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'question.self', 0, 1, '2018-04-02 00:24:39', 78, '2018-04-02 05:04:04', 78, ''),
(NULL, '%SITENAME% | %SELLER_COMPANY% has replied to your question', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 80px 0 20px;\"><a href=\"http://sellacious.com/\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello %SENDER_NAME%,</h2>\r\n<h2 style=\"font-size: 18px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">%SELLER_COMPANY% has replied to your question which you asked for the product <a href=\"%PRODUCT_URL%\" target=\"_blank\" rel=\"noopener noreferrer\">%PRODUCT_NAME%</a>.</h2>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0 10px; text-align: justify;\"><b>%QUESTION%</b></div>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0 10px; text-align: justify;\"><em>%ANSWER%</em></div>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0 10px; text-align: justify;\"><del>%PREVIOUS_ANSWER%</del></div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<p style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #676d76; margin: 10px 0 0; padding: 20px 0; text-align: center; background-color: #d3ebff;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'question.reply', 0, 1, '2018-04-02 04:47:30', 78, '2018-04-02 05:51:01', 78, ''),
(NULL, '%SITENAME% | New Product Created', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 80px 0 20px;\"><a href=\"%SITE_URL%\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello Admin,</h2>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0; text-align: justify;\">A New product, <a style=\"text-decoration: none;\" href=\"%PRODUCT_URL%\">%PRODUCT_NAME%</a> with status %STATUS% has created at <a style=\"text-decoration: none;\" href=\"%SITE_URL%\">%SITENAME%</a> on %DATE% by %SELLER_COMPANY% .</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<p style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #676d76; margin: 10px 0 0; padding: 20px 0; text-align: center; background-color: #d3ebff;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'product.admin', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, ''),
(NULL, '%SITENAME% | Product Notification ', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 80px 0 20px;\"><a href=\"%SITE_URL%\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello Admin,</h2>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0; text-align: justify;\">%TOTAL_PRODUCTS% Products have created at <a style=\"text-decoration: none;\" href=\"%SITE_URL%\">%SITENAME%</a> in last %TIME_DURATION% .</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<p style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #676d76; margin: 10px 0 0; padding: 20px 0; text-align: center; background-color: #d3ebff;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'product_notification.admin', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '{\"intervals\":[\"1 day\",\"1 week\",\"30 day\"]}'),
(NULL, '%SITENAME% | Product Status Changed', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 80px 0 20px;\"><a href=\"%SITE_URL%\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello %SELLER_COMPANY%,</h2>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0; text-align: justify;\">Status of the <a style=\"text-decoration: none;\" href=\"%PRODUCT_URL%\">%PRODUCT_NAME%</a> has been changed to new status <strong>%STATUS%</strong> at <a style=\"text-decoration: none;\" href=\"%SITE_URL%\">%SITENAME%</a> .</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<p style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #676d76; margin: 10px 0 0; padding: 20px 0; text-align: center; background-color: #d3ebff;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'product_status.seller', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, ''),
(NULL, '%SITENAME% | Product for Approval', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 80px 0 20px;\"><a href=\"%SITE_URL%\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello Admin,</h2>\r\n<div style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444444; margin: 0 0; text-align: justify;\">A product, <a style=\"text-decoration: none;\" href=\"%PRODUCT_URL%\">%PRODUCT_NAME%</a> with status %STATUS% is pending for Approval at <a style=\"text-decoration: none;\" href=\"%SITE_URL%\">%SITENAME%</a> .</div>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<p style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #676d76; margin: 10px 0 0; padding: 20px 0; text-align: center; background-color: #d3ebff;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'product_approval.admin', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, ''),
(NULL, '%SITENAME% | Password Reset ', '<table style=\"background: #f5f5f5;\" border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 100px 0 20px;\"><a href=\"http://sellacious.com/\"><img src=\"http://sellacious.com/images/sellacious-logo-main.png\" alt=\"Sellacious\" /></a></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>\r\n<table style=\"margin: auto; border-radius: 5px; -webkit-border-radius: 5px; -moz-border-radius: 5px; background: #fff;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"padding: 25px 35px 20px;\">\r\n<h2 style=\"font-size: 24px; font-family: helvetica,arial,sans-serif; line-height: 30px; color: #222; margin: 10px 0; font-weight: normal;\">Hello %FULL_NAME%,</h2>\r\n<p style=\"font-size: 14px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444; margin: 0 0 10px; text-align: justify;\">A request has been made to reset your %SITENAME% account password. To reset your password, you will need to submit this verification code in order to verify that the request was legitimate. <br />The verification code is <strong>%VERIFICATION_CODE%</strong></p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"margin: 0;\"><a style=\"font-size: 16px; font-family: helvetica,arial,sans-serif; line-height: 22px; background-color: #3070a9; color: #fff; padding: 8px 0px; display: inline-block; text-decoration: none; width: 100%; max-width: 300px; margin-bottom: 35px;\" href=\"%VERIFICATION_URL%\"> Click Here To Reset Your Password </a></p>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center; padding: 25px 35px; background-color: #d3ebff;\">\r\n<p style=\"font-size: 14px; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #444; margin: 0 0 10px;\">Your %SITENAME% Team!!</p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table style=\"margin: 20px auto 70px;\" border=\"0\" width=\"650\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\">\r\n<p style=\"font-size: 12px; text-align: center; font-family: helvetica,arial,sans-serif; line-height: 20px; color: #555; margin: 0 0; font-weight: normal;\">For more information, visit our site <a style=\"font-size: 12px; font-family: helvetica,arial,sans-serif; color: #5551f7;\" href=\"%SITE_URL%\">%SITENAME%</a></p>\r\n<p style=\"margin: 5px 0 0;\"><a style=\"margin: 0 3px;\" href=\"https://www.facebook.com/sellacious/?fref=ts\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-facebook.png\" /></a> <a style=\"margin: 0 3px;\" href=\"https://twitter.com/SellaciousCom\"><img src=\"http://d3qngc7ypzt3ty.cloudfront.net/blog/icon-tweet.png\" /></a></p>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '', '', '', '', '', 1, 'password_reset.self', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '');

ALTER TABLE `#__sellacious_products`
ADD `language` varchar(7) NOT NULL COMMENT 'The language code for the product.' AFTER `params`;

ALTER TABLE `#__sellacious_cache_products`
ADD `language` varchar(7) NOT NULL;

ALTER TABLE `#__sellacious_product_sellers`
ADD `params` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL AFTER `modified_by`;

ALTER TABLE `#__sellacious_sellers`
ADD `params` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL AFTER `modified_by`;

ALTER TABLE `#__sellacious_licenses`
ADD `alias` VARCHAR(250) NOT NULL AFTER `title`;

ALTER TABLE `#__sellacious_transactions`
ADD `user_id` INT NOT NULL AFTER `txn_number`;

ALTER TABLE `#__sellacious_shoprules`
ADD `filterable` INT NOT NULL AFTER `type`;

ALTER TABLE `#__sellacious_products`
ADD `primary_video_url` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL AFTER `metadesc`;

ALTER TABLE `#__sellacious_cache_products`
ADD `primary_video_url` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL AFTER `metadesc`;

ALTER TABLE `#__sellacious_product_sellers`
ADD `disable_stock` INT NOT NULL AFTER `seller_uid`;
