/**
 * @version     2.0.0
 * @package     sellacious
 *
 * @copyright   Copyright (C) 2012-2020 Bhartiy Web Technologies. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Izhar Aazmi <info@bhartiy.com> - http://www.bhartiy.com
 */
(function ($) {
	$(document).on('change', '.jff-radioswitch-ui', function() {
		const value = $(this).data(this.checked ? 'true' : 'false');
		$(this).closest('.jff-radioswitch').find('input[name]').val(value).trigger('change');
	});

	$(document).on('radioswitch:update', '.jff-radioswitch', function(e, checked, silent) {
		const ui = $(this).find('.jff-radioswitch-ui');
		const el = $(this).find('input[name]');

		ui.prop('checked', checked);
		const value = ui.data(checked ? 'true' : 'false');
		el.val(value);
		silent || el.trigger('change');
	});
})(jQuery);
