<?php
/**  
 * @package INSTANTPAYPAL::administrator::components::com_instantpaypal
 * @author Joomla! Extensions Store
 * @copyright (C) 2015 - Joomla! Extensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html   
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' ); 
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;

/** 
 * Script to manage install/update/uninstall for component. Follow class convention
 * @package INSTANTPAYPAL::administrator::components::com_instantpaypal  
 */
class PlgcontentinstantpaypalInstallerScript {
	/*
	* Find mimimum required joomla version for this extension. It will be read from the version attribute (install tag) in the manifest file
	*/
	private $minimum_joomla_release = '4.0';
	
	/*
	 * $parent is the class calling this method.
	 * $type is the type of change (install, update or discover_install, uninstall).
	 * preflight runs before anything else and while the extracted files are in the uploaded temp folder.
	 * If preflight returns false, Joomla will abort the update and undo everything already done.
	 */
	function preflight($type, $parent) {
		// Check for Joomla compatibility
		if(version_compare(JVERSION, $this->minimum_joomla_release, '<')) {
			Factory::getApplication()->enqueueMessage (Text::sprintf('PLG_CONTENT_INSTANTPAYPAL_INSTALLING_VERSION_NOTCOMPATIBLE', JVERSION), 'error');
			return false;
		} 
	}
}