<?php
/**
 * Joomla! 3.0 component Collector
 *
 * @package 	Collector
 * @copyright   Copyright (C) 2010 - 2020 Philippe Ousset. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 *
 * Collector is a Multi Purpose Listing Tool.
 * Originaly developped to list Collections
 * it can be used for several purpose.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.model' );
jimport( 'joomla.filesystem.folder' );
jimport( 'joomla.filesystem.file' );

jimport('joomla.application.component.modellist');

/**
 * Folderselect model
 * @package	Collector
 */
class CollectorModelFolderselect extends JModelList
{
	/**
	 * The relative Path from site root to the current folder
	 * @var string 
	 */
	var $_folder;
	
	/**
	 * The elements
	 * @var array 
	 */
	var $_elements;
	
	/**
	 * The task
	 * @var string 
	 */
	var $_task;
	
	/**
	 * The path to the current folder
	 * @var array 
	 */
	var $_path;
	
	/**
	 * Folderselect model constructor
	 *
	 * @access	public
	 */
	function __construct()
	{
		parent::__construct();
		
		$application = JFactory::getApplication();
		$input  = $application->input;
		$this->_elements = $input->get('cid', '', 'array');
		$this->_task = $input->getWord('task');
		
		// Get folder request variables
		$this->_folder = $application->getUserStateFromRequest('collector.filemanager.folder', 'folder', '', 'text');
		
		$this->_path = array();
		$tmp = new JObject();
		$tmp->name = JText::_( 'COM_COLLECTOR_ROOT' );
		$tmp->path = '';
		$this->_path[] = $tmp;
		
		if ( $this->_folder != '' )
		{
			$this->cleanPath();
		}
	}
	
	/**
	 * Retrieve the current folder
	 *
	 * @access	public
	 * @return	string	Relative Path from site root
	 */
	function getFolder()
	{
		return $this->_folder;
	}
	
	/**
	 * Retrieve the task
	 *
	 * @access	public
	 * @return	string	Task
	 */
	function getTask()
	{
		return $this->_task;
	}
	
	/**
	 * Retrieve the elements
	 *
	 * @access	public
	 * @return	string	Task
	 */
	function getElements()
	{
		return $this->_elements;
	}
	
	/**
	 * Image Manager Popup
	 *
	 * @param string $listFolder The image directory to display
	 * @since 1.5
	 */
	function getFolderList($base = null)
	{
		// Get some paths from the request
		if (empty($base))
		{
			$base = COM_COLLECTOR_BASE;
		}
		//corrections for windows paths
		$base = str_replace(DIRECTORY_SEPARATOR, '/', $base);
		$com_media_base_uni = str_replace(DIRECTORY_SEPARATOR, '/', COM_COLLECTOR_BASE);

		// Get the list of folders
		jimport('joomla.filesystem.folder');
		$folders = JFolder::folders($base, '.', true, true);

		$document = JFactory::getDocument();
		$document->setTitle(JText::_('COM_MEDIA_INSERT_IMAGE'));

		// Build the array of select options for the folder list
		$options[] = JHtml::_('select.option', "", "/");

		foreach ($folders as $folder)
		{
			$folder		= str_replace($com_media_base_uni, "", str_replace(DIRECTORY_SEPARATOR, '/', $folder));
			$value		= substr($folder, 1);
			$text		= str_replace(DIRECTORY_SEPARATOR, "/", $folder);
			$options[]	= JHtml::_('select.option', $value, $text);
		}

		// Sort the folder list array
		if (is_array($options))
		{
			sort($options);
		}

		// Create the drop-down folder select list
		$list = JHtml::_('select.genericlist', $options, 'folderlist', 'class="inputbox" size="1" onchange="FileManager.setFolder(this.options[this.selectedIndex].value)" ', 'value', 'text', $base);

		return $list;
	}
	
	/**
	 * Retrieves list of folders and files from a folder
	 *
	 * @access	public
	 * @param	string	$baseFolder	Relative Path from site root
	 * @return	array				Array of objects containing the data from the filesystem
	 */
	function getList($baseFolder = null)
	{
		$baseSite = JPATH_ROOT.'/';
		
		//Si aucun dossier specifie on va a la racine du site
		if ( $baseFolder == null )
		{
			if ( $this->_folder == '' )
			{
				$baseFolder = JPATH_ROOT.'/';
			}
			else
			{
				$baseFolder = JPATH_ROOT.'/'.$this->_folder;
				
				$precFolder = implode ( '/' , explode( '/', $baseFolder, -1 ) );
				
				$prec = new JObject();
				$prec->name = JText::_('COM_COLLECTOR_BACK_DIRECTORY');
				$prec->type = '';
				$prec->ico = 'components/com_collector/assets/images/folder_back.png';
				$prec->path = JPath::clean($precFolder);
				if ( $prec->path.'/' == $baseSite )
				{
					$prec->path_relative = '';
				}
				else
				{
					$prec->path_relative = str_replace($baseSite, '', $prec->path);
				}
				//$count = MediaHelper::countFiles($prec->path);
				//$prec->files = $count[0];
				//$prec->folders = $count[1];
				
				$folders[] = $prec;
			}
		}
		else
		{
			$baseFolder = JPATH_ROOT.'/'.$baseFolder;
		}
		
		$extensions = $this->getExtensions();
		
		$foldersList = JFolder::folders($baseFolder);
		$filesList = JFolder::files($baseFolder);
		
		$files = array();
		
		if ( $filesList != null )
		{
			foreach ( $filesList as $file )
			{
				$ext = strtolower(JFile::getExt($file));
				
				if ( array_key_exists( $ext, $extensions ) )
				{
					$tmp = new JObject();
					$tmp->name = $file;
					$tmp->path = JPath::clean($baseFolder.'/'.$file);
					$tmp->path_relative = str_replace($baseSite, '', $tmp->path);
					$tmp->size = $this->get_file_size($tmp->path);
					$tmp->modified = $this->get_file_date($tmp->path);
					$tmp->type = $extensions[$ext]->type;
					$tmp->text = JText::_('COM_COLLECTOR_'.$extensions[$ext]->text);
					$tmp->ico = 'components/com_collector/assets/images/'.$extensions[$ext]->ico;
					$files[] = $tmp;
				}
			}
			
		}
		
		if ( $foldersList != null )
		{
			foreach ( $foldersList as $folder )
			{
				$tmp = new JObject();
				$tmp->name = basename($folder);
				$tmp->text = JText::_('COM_COLLECTOR_DIRECTORY');
				$tmp->ico = 'components/com_collector/assets/images/folder.png';
				$tmp->path = JPath::clean($baseFolder.'/'.$folder);
				$tmp->path_relative = str_replace($baseSite, '', $tmp->path);
				//$count = MediaHelper::countFiles($tmp->path);
				//$tmp->files = $count[0];
				//$tmp->folders = $count[1];
				
				$folders[] = $tmp;
			}
		}
		
		$this->list = array('folders' => $folders, 'files' => $files);
		
		return $this->list;
	}
	
	/**
	 * Check folder from request
	 * Clean <var>_folder</var>
	 *
	 * @access	public
	 * @return	void
	 */
	function cleanPath()
	{
		$this->_folder = str_replace('\\','/',$this->_folder);
		$path = explode('/',$this->_folder);
		
		$i = 0;
		
		foreach ( $path as $folder )
		{
			if ( $folder == '..' )
			{
				$i = $i - 1;
				if ( $i < 0 )
				{
					$cleanPath = array();
					$this->_path = array();
					$tmp = new JObject();
					$tmp->name = JText::_( 'COM_COLLECTOR_ROOT' );
					$tmp->path = '';
					$this->_path[] = $tmp;
					break;
				}
				else
				{
					unset($cleanPath[$i]);
					unset($this->_path[$i]);
				}
			}
			else
			{
				if ( $folder != '.' )
				{
					$cleanPath[] = $folder;
					$tmp = new JObject();
					$tmp->name = $folder;
					$tmp->path = implode('/', $cleanPath);
					$this->_path[] = $tmp;
					$i = $i + 1;
				}
			}
		}
		
		$this->_folder = implode('/', $cleanPath);
	}
	
	/**
	 * Retrieve extensions available
	 *
	 * @access	public
	 * @return	object	Array of extensions objects
	 */
	function getExtensions()
	{
		$query = 'SELECT e.id, t.text, e.type, e.ext, e.ico, e.state';
		$query .= ' FROM `#__collector_files_ext` AS e';
		$query .= ' LEFT JOIN `#__collector_files_type` AS t ON e.type = t.id';
		
		$db = $this->getDBO();
		
		$db->setQuery($query);
		$db->execute();
		
		$this->_ext = $db->loadObjectList ( 'ext' );
		
		return $this->_ext;
	}
	
	/**
	 * Retrieve size file from filesystem
	 *
	 * @access	public
	 * @return	string	Size
	 */
	function get_file_size($filename)
	{
		$size_in_bytes = filesize($filename);
		
		$precision = 0;
		
		if ( $size_in_bytes < 1024 )
		{
			$unit = ' bytes';
			$size = $size_in_bytes;
		}
		else
		{
			$size_in_kilobytes = (($size_in_bytes / 1024));
			
			if ( $size_in_kilobytes < 1024 )
			{
				$unit = ' Kb';
				$size = round($size_in_kilobytes, $precision) ? round($size_in_kilobytes, $precision) : 1;
			}
			else
			{
				$size_in_megabytes = (($size_in_kilobytes / 1024));
				
				$unit = ' Mb';
				$size = round($size_in_megabytes, $precision) ? round($size_in_megabytes, $precision) : 1;
			}
		}
		
		return $size.$unit;
	}
	
	/**
	 * Retrieve date file from filesystem
	 *
	 * @access	public
	 * @return 	string 	Date html
	 */
	function get_file_date($filename)
	{
		$config = JFactory::getConfig();
		$tzoffset = $config->get('config.offset');
		$date = JFactory::getDate(filemtime($filename), $tzoffset);
		$modified = $date->toSql();
		
		return JHTML::_( 'date', $modified, '%Y-%m-%d %H:%M:%S');
	}
	
	/**
	 * Construct Path links for navigation in the filesystem
	 *
	 * @access	public
	 * @return 	string 	Navigation html
	 */
	function get_path_navigation()
	{
		$navigation = '';
		
		foreach ($this->_path as $folder)
		{
			$navigation .= '<a href="' . JRoute::_( 'index.php?option=com_collector&amp;view=folderselect&amp;tmpl=component&amp;folder='.$folder->path ) . '" >' . $folder->name . '</a>/';
		}
		
		return $navigation;
	}
	
	/**
	 * Method to remove files
	 *
	 * @access	public
	 * @return	string	Message to display
	 */
	function remove()
	{
		$app = JFactory::getApplication();
		$cid = $app->input->get( 'cid', array(0), '', 'array');
		$deleted = array( "files" => 0 , "folders" => 0 );
		
		foreach ($cid as $id)
		{
			$path = JPath::clean(JPATH_ROOT.'/'.$id);
			
			if (!is_dir($path))
			{
				if (is_file($path))
				{
					if ( JFile::delete($path) )
					{
						$deleted[files]++;
					}
				}
			}
			else
			{
				$filesList = JFolder::files($path,'.',true,true);
				$candelete = 1;
				
				foreach ( $filesList as $file )
				{
					if ( JFile::getName($file) != 'index.html' )
					{
						$candelete = 0;
						break;
					}
					else
					{
						$content = file_get_contents($file);
						$blank = "<html><body bgcolor=\"#FFFFFF\"></body></html>";
						if ( $content != $blank )
						{
							$candelete = 0;
							break;
						}
					}
				}
				if ( $candelete == 1 )
				{
					if ( JFolder::delete($path) )
					{
						$deleted[folders]++;
					}
				}
			}
		}
		
		$msg[0] = $deleted[files] . ' ' . JText::_( 'COM_COLLECTOR_FILE_DELETED' ) . ' & ' . $deleted[folders] . ' ' . JText::_( 'COM_COLLECTOR_FOLDER_DELETED' );
		if ( $deleted[files]+$deleted[folders] == count($cid) )
		{
			$msg[1] = 'message';
		}
		else
		{
			$msg[0] .= ' ; ' . JText::_( 'COM_COLLECTOR_NO_DELETED' );
			$msg[1] = 'error';
		}
		
		return $msg;
	}
	
	/**
	 * Method to create folder
	 *
	 * @access	public
	 * @return	string	Message to display
	 */
	function createFolder()
	{
		$app = JFactory::getApplication();
		$folder = $app->input->get('foldername', '', '', 'text');
		
		if (strlen($folder) > 0) {
			$path = JPath::clean(JPATH_ROOT.'/'.$this->_folder.'/'.$folder);
			if (!is_dir($path))
			{
				if (!is_file($path))
				{
					JFolder::create($path);
					JFile::write($path.'/'."index.html", "<html><body bgcolor=\"#FFFFFF\"></body></html>");
					$msg[0] = '"' . $folder . '" ' . JText::_( 'COM_COLLECTOR_FOLDER_CREATED' );
					$msg[1] = 'message';
				}
				else
				{
					$msg[0] = JText::_( 'COM_COLLECTOR_EXIST_FILE_SAME' );
					$msg[1] = 'error';
				}
			}
			else
			{
				$msg[0] = JText::_( 'COM_COLLECTOR_EXIST_FOLDER_SAME' );
				$msg[1] = 'error';
			}
			
		}
		else
		{
			$msg[0] = JText::_( 'COM_COLLECTOR_NO_FOLDER_NAME' );
			$msg[1] = 'error';
		}
		
		return $msg;
	}
	
	/**
	 * Method to rename file or folder
	 *
	 * @access	public
	 */
	function rename()
	{
		$app = JFactory::getApplication();
		$renameElement = $app->input->get('renameElement', '', '', 'text');
		$rename = $app->input->get('rename', '', '', 'text');
		
		$path = JPath::clean(JPATH_ROOT.'/'.$this->_folder.'/');
		
		if ( JFolder::exists( $path . $renameElement ) )
		{
			JFolder::move( $path . $renameElement , $path . $rename );
		}
		else
		{
			JFile::move( $path . $renameElement , $path . $rename );
		}
	}
}