<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

/**
 * Document controller class.
 */
class DigitalMarketXControllerDocument extends JControllerForm
{

    function __construct() {
        $this->view_list = 'documents';
        parent::__construct();
    }
	
	protected function allowEdit($data = array(), $key = 'parent_id')
	{
		$user = JFactory::getUser();
		$recordId = (int) isset($data[$key]) ? $data[$key] : 0;
		$category = (int) isset($data['category']) ? $data['category'] : 0;
		if(empty($category) && $recordId)
		{
			$record = $this->getModel()->getItem($recordId);
			if (!empty($record))
			{
				$category = $record->category;
			}
		}
		if(!empty($category))
			$asset = 'com_digitalmarketx.category.' . $category;
		else
			$asset = 'com_digitalmarketx';
		$canEdit = $user->authorise('core.edit', $asset);
		if(!$canEdit)
		{
			if($user->authorise('core.edit.own', $asset))
			{
				$recordId = (int) isset($data[$key]) ? $data[$key] : 0;
				$ownerId = (int) isset($data['created_user_id']) ? $data['created_user_id'] : 0;
				if (empty($ownerId) && $recordId)
				{
					// Need to do a lookup from the model.
					$record = $this->getModel()->getItem($recordId);
					if (!empty($record))
					{
						$ownerId = $record->created_user_id;
					}
				}
				if (!empty($ownerId))
					$canEdit = $ownerId == $user->id;
			}
		}
		return $canEdit;
	}

}