<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

/**
 * Document controller class.
 */
class DigitalMarketXControllerDownloadlink extends JControllerForm
{

    function __construct() {
        $this->view_list = 'downloadlinks';
        parent::__construct();
    }

	protected function allowEdit($data = array(), $key = 'parent_id')
	{
		$user = JFactory::getUser();
		$canEdit = $user->authorise('core.edit', 'com_digitalmarketx');
		return $canEdit;
	}
	
	function addnew()
	{
		// Initialise variables.
		$app = JFactory::getApplication();
		$context = "$this->option.edit.$this->context";

		// Access check.
		if (!$this->allowAdd())
		{
			// Set the internal error and also the redirect error.
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_CREATE_RECORD_NOT_PERMITTED'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_list
					. $this->getRedirectToListAppend(), false
				)
			);

			return false;
		}

		// Clear the record edit information from the session.
		$app->setUserState($context . '.data', null);

		// Redirect to the edit screen.
		$this->setRedirect(
			JRoute::_(
				'index.php?option=' . $this->option . '&view=adddownloadlink' 
				. $this->getRedirectToItemAppend(), false
			)
		);

		return true;
	}
	
	function createdownloadlink()
	{
		$data = JRequest::getVar('jform', null, 'default', 'array');
		$model = $this->getModel();
		$model->createDownloadLink($data['item_id'], $data['payer_email']);
		// Redirect to the edit screen.
		$this->setRedirect(
			JRoute::_(
				'index.php?option=' . $this->option . '&view=downloadlinks', false
			)
		);

		return true;
	}
}