<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.controlleradmin');

/**
 * Configurations list controller class.
 */
class DigitalMarketXControllerReports extends JControllerAdmin
{
	/**
	 * Authorisation check
	 *
	 * @param   string  $task  The ACO Section Value to check access on.
	 *
	 * @return  boolean  True if authorised
	 *
	 * @since   11.1
	 */
	public function authorise($task)
	{
		$user = JFactory::getUser();
		return $user->authorise('core.manage', 'com_digitalmarketx');
	}

	
	/**
	 * Proxy for getModel.
	 * @since	1.6
	 */
	public function getModel($name = 'report', $prefix = 'DigitalMarketXModel')
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}
}