<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.controlleradmin');

/**
 * Documents list controller class.
 */
class DigitalMarketXControllerUsers extends JControllerAdmin
{

	public function pay()
	{
		$app = JFactory::getApplication();
		$app->redirect("index.php?option=com_digitalmarketx&view=payuser");
	}
	
	public function cancel()
	{
		$app = JFactory::getApplication();
		$app->redirect("index.php?option=com_digitalmarketx&view=users");
	}
	
	public function updatebalance()
	{
		if(EDIT_USER_BALANCE && JFactory::getUser()->authorise('digitalmarketx.update_user_balance', 'com_digitalmarketx'))
		{
			$user_id = JRequest::getInt('user_id');
			$count = JRequest::getInt('money_count');
			$model = $this->getModel('users');
			for($i = 0; $i < $count; $i++)
			{
				$id = JRequest::getInt('money_id_' . $i);
				$balance = JRequest::getFloat('balance_' . $i);
				$claimed = JRequest::getFloat('claimed_' . $i);
				$model->updateMoney($id, $balance, $claimed);
			}
		}
		$app = JFactory::getApplication();
		$app->redirect("index.php?option=com_digitalmarketx&view=users",
			JText::_("COM_DIGITALMARKETX_BALANCE_UPDATED"));
	}
}