<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */


// no direct access
defined('_JEXEC') or die;

// Access check.
if (!JFactory::getUser()->authorise('core.manage', 'com_digitalmarketx')) 
{
	throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'));
}

// Include dependancies
jimport('joomla.application.component.controller');


$version = new JVersion();
if($version->RELEASE < "3.0")
{
	if(!class_exists("JModelLegacy"))
		require_once dirname(__FILE__).'/legacy/modellegacy.php';
	if(!class_exists("JControllerLegacy"))
		require_once dirname(__FILE__).'/legacy/controllerlegacy.php';
	if(!class_exists("JViewLegacy"))
		require_once dirname(__FILE__).'/legacy/viewlegacy.php';
}
else
{
	require_once (dirname(__FILE__).'/backcompat.php');
}
require_once (dirname(__FILE__).'/compat.php');
$controller	= JControllerLegacy::getInstance('DigitalMarketX');
$controller->execute(JFactory::getApplication()->input->get('task'));
$controller->redirect();