<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

/**
 * DigitalMarketX helper.
 */
class DigitalMarketXHelper
{
	/**
	 * Configure the Linkbar.
	 */
	public static function addSubmenu($vName = '')
	{
		$user = JFactory::getUser();
		DigitalMarketXHelper::addMenuEntry(
			JText::_('COM_DIGITALMARKETX_TITLE_DOCUMENTS'),
			'index.php?option=com_digitalmarketx&view=documents',
			$vName == 'documents'
		);
		DigitalMarketXHelper::addMenuEntry(
			JText::_('COM_DIGITALMARKETX_DOCUMENTS_CATEGORY'),
			'index.php?option=com_categories&extension=com_digitalmarketx',
			$vName == 'categories.category'
		);
		DigitalMarketXHelper::addMenuEntry(
			JText::_('COM_DIGITALMARKETX_TITLE_VOTES'),
			'index.php?option=com_digitalmarketx&view=votes',
			$vName == 'votes'
		);
		DigitalMarketXHelper::addMenuEntry(
			JText::_('COM_DIGITALMARKETX_REPORTS'),
			'index.php?option=com_digitalmarketx&view=reports',
			$vName == 'reports'
		);
		DigitalMarketXHelper::addMenuEntry(
				JText::_('COM_DIGITALMARKETX_DOWNLOAD_LINKS'),
				'index.php?option=com_digitalmarketx&view=downloadlinks',
				$vName == 'downloadlinks'
			);
		DigitalMarketXHelper::addMenuEntry(
				JText::_('COM_DIGITALMARKETX_PAYMENTS'),
				'index.php?option=com_digitalmarketx&view=payments',
				$vName == 'payments'
			);
		DigitalMarketXHelper::addMenuEntry(
				JText::_('COM_DIGITALMARKETX_USERS'),
				'index.php?option=com_digitalmarketx&view=users',
				$vName == 'users'
			);
		DigitalMarketXHelper::addMenuEntry(
				JText::_('COM_DIGITALMARKETX_CURRENCIES_RATES'),
				'index.php?option=com_digitalmarketx&view=currencies',
				$vName == 'currencies'
			);
		DigitalMarketXHelper::addMenuEntry(
				JText::_('COM_DIGITALMARKETX_TITLE_TEMPLATES'),
				'index.php?option=com_digitalmarketx&view=templates',
				$vName == 'templates'
			);
		DigitalMarketXHelper::addMenuEntry(
				JText::_('COM_DIGITALMARKETX_ABOUT'),
				'index.php?option=com_digitalmarketx&view=about',
				$vName == 'about'
			);
	}
	
	static public function notifyReport($doc_id, $doc_title, 
		$report_title, $report_text)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$notification_email = $params->get('notification_email');
		if($notification_email)
		{
			$notification_subject = $params->get('report_subject', 'There is a new report');
			$notificationbody = $params->get('report_body', 'There is a new report for document {document}. {link}');
			$notification_subject = self::doReportNotificationReplacements(
				$doc_id, $doc_title, 
				$report_title, $report_text,
				$notification_subject);
			$notificationbody = self::doReportNotificationReplacements(
				$doc_id, $doc_title, 
				$report_title, $report_text,
				$notificationbody);
			$mail = JFactory::getMailer();
			$mail->clearAddresses();
			$mail->addRecipient($notification_email);
			$mail->setSubject($notification_subject);
			$mail->setBody($notificationbody);
			$mail->IsHTML(true);
			$joomla_config = new JConfig();
			$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
			$mail->send();
		}
	}
	
	static private function doReportNotificationReplacements(
		$doc_id, $doc_title, 
		$report_title, $report_text, $text)
	{
		$text = str_replace("{document}", $doc_title, $text);
		$url = JUri::root() . "index.php?option=com_digitalmarketx&view=details&id=" . (int)$doc_id;
		$text = str_replace("{link}", "<a href=\"$url\">$url</a>", $text);
		$text = str_replace("{doc_url}", $url, $text);
		$text = str_replace("{report_subject}", $report_title, $text);
		$text = str_replace("{report_text}", $report_text, $text);
		return $text;
	}
	
	static private function addMenuEntry($text, $url, $active)
	{
		$version = new JVersion();
		if($version->RELEASE < "3.0")
		{
			JSubMenuHelper::addEntry( $text, $url, $active );
		}
		else
		{
			JHtmlSidebar::addEntry( $text, $url, $active );
		}
	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return	JObject
	 * @since	1.6
	 */
	public static function getActions()
	{
		$user	= JFactory::getUser();
		$result	= new JObject;

		$assetName = 'com_digitalmarketx';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}
	
	static public function notifyStateChange($doc_id, $doc_title, $new_state, $users)
	{
		if($new_state == 1)
		{
			$params = JComponentHelper::getParams('com_digitalmarketx');
			$notification_subject = $params->get('publish_subject', '');
			$notificationbody = $params->get('publish_body', '');
			$owner = DigitalMarketXHelper::getDocumentOwner($doc_id);
			$currentUser = JFactory::getUser();
			$mail = JFactory::getMailer();
			$mail->clearAddresses();
			$addr_count = 0;
			if($currentUser->id != $owner)
			{
				$ownerEmail = JFactory::getUser($owner)->email;
				$mail->addRecipient($ownerEmail);
				$addr_count++;
			}
			if(isset($users) && $users != null)
			{
				if(is_array($users))
				{
					foreach($users as $user)
					{
						if($user && $currentUser->id != $user->user_id)
						{
							$userObj = JFactory::getUser($user->user_id);
							$mail->addRecipient($userObj->email);
							$addr_count++;
						}
					}
				}
				else
				{
					$users = explode(",", $users);
					foreach($users as $user)
					{
						$user = (int)$user;
						if($user && $user != $currentUser->id)
						{
							$userObj = JFactory::getUser($user);
							$mail->addRecipient($userObj->email);
							$addr_count++;
						}
					}
				}
			}
			if($addr_count)
			{
				$notification_subject = DigitalMarketXHelper::_doStateChangedEmailReplacements($docid, $doc_title, $new_state, $notification_subject);
				$notificationbody = DigitalMarketXHelper::_doStateChangedEmailReplacements($docid, $doc_title, $new_state, $notificationbody);
				$mail->setSubject($notification_subject);
				$mail->setBody($notificationbody);
				$mail->IsHTML(true);
				$joomla_config = new JConfig();
				$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
				$mail->send();
			}
		}
	}
	
	public function notifyUpload($docid, $document_title, $users)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$notification_email = $params->get('notification_email', '');
		if($notification_email)
		{
			$state = DigitalMarketXHelper::getDocumentState($docid);
			$notification_subject = $params->get('upload_subject', '');
			$notificationbody = $params->get('upload_body', '');
			$notification_subject = DigitalMarketXHelper::_doUploadEmailReplacements($docid, $document_title, $state, $notification_subject);
			$notificationbody = DigitalMarketXHelper::_doUploadEmailReplacements($docid, $document_title, $state, $notificationbody);
			
			$mail = JFactory::getMailer();
			$mail->setSubject($notification_subject);
			$mail->setBody($notificationbody);
			$emails = explode(';', $notification_email);
			$mail->ClearAddresses();
			$addr_count = 0;
			foreach($emails as $addr)
			{
				$mail->addRecipient($addr);
				$addr_count++;
			}
			if($users != null)
			{
				if(is_array($users))
				{
					foreach($users as $user)
					{
						$userObj = JFactory::getUser($user->user_id);
						$mail->addRecipient($userObj->email);
						$addr_count++;
					}
				}
				else
				{
					$users = explode(",", $users);
					foreach($users as $user)
					{
						$user = (int)$user;
						if($user)
						{
							$userObj = JFactory::getUser($user);
							$mail->addRecipient($userObj->email);
							$addr_count++;
						}
					}
				}
			}
			if($addr_count)
			{
				$mail->IsHTML(true);
				$joomla_config = new JConfig();
				$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
				$mail->send();
			}
		}
	}
	
	static public function notifyClaim($moneyCurrencyId, $amount)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$notification_email = $params->get('notification_email', '');
		if($notification_email)
		{
			$notification_subject = $params->get('money_claim_subject', '');
			$notificationbody = $params->get('money_claim_body', '');
			$db = JFactory::getDBO();
			$query = "SELECT claimed, currency FROM #__digitalmarketx_users_money WHERE money_id = " . (int)$moneyCurrencyId;
			$db->setQuery( $query );
			$claim = $db->loadObject();
			if($claim)
			{
				$notification_subject = DigitalMarketXHelper::_doClaimEmailReplacements($amount, $claim->currency, $notification_subject);
				$notificationbody = DigitalMarketXHelper::_doClaimEmailReplacements($amount, $claim->currency, $notificationbody);
				$mail = JFactory::getMailer();
				$mail->setSubject($notification_subject);
				$mail->setBody($notificationbody);
				$emails = explode(';', $notification_email);
				$mail->ClearAddresses();
				foreach($emails as $addr)
				{
					$mail->addRecipient($addr);
				}
				$mail->IsHTML(true);
				$joomla_config = new JConfig();
				$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
				$mail->send();
			}
		}
	}
	
	static private function getDocumentOwner($docId)
	{
		$db = JFactory::getDBO();
		$query = "SELECT created_user_id FROM #__digitalmarketx_documents WHERE id = " . (int)$docId;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	static private function _doStateChangedEmailReplacements($docid, $document_title, $state, $text)
	{
		$text = preg_replace('/{document}/', '"' . $document_title . '"', $text);
		$link = JUri::root() . "index.php?option=com_digitalmarketx&view=details&id=" . $docid;
		$text = preg_replace("/{link}/", "<a href=\"$link\">$link</a>", $text);
		$text = str_replace("{doc_url}", $link, $text);
		$text = preg_replace("/{state}/", $state ? JText::_("JPUBLISHED") : JText::_("JUNPUBLISHED"), $text);
		return $text;
	}
	
	static private function _doUploadEmailReplacements($docid, $document_title, $state, $text)
	{
		$text = preg_replace('/{document}/', '"' . $document_title . '"', $text);
		$text = preg_replace("/{user}/", JFactory::getUser()->name, $text);
		$link = JUri::root() . "index.php?option=com_digitalmarketx&view=details&id=" . $docid;
		$text = preg_replace("/{link}/", "<a href=\"$link\">$link</a>", $text);
		$text = str_replace("{doc_url}", $link, $text);
		$text = preg_replace("/{state}/", $state ? JText::_("JPUBLISHED") : JText::_("JUNPUBLISHED"), $text);
		return $text;
	}
	
	static private function _doClaimEmailReplacements($amount, $currency, $text)
	{
		$text = preg_replace("/{amount}/", $amount, $text);
		$text = preg_replace("/{user}/", JFactory::getUser()->name, $text);
		$text = preg_replace("/{currency}/", $currency, $text);
		return $text;
	}
	
	static public function getDocumentState($docId)
	{
		$db = JFactory::getDBO();
		$query = "SELECT state FROM #__digitalmarketx_documents WHERE id = " . (int)$docId;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	static public function getDocumentCategory($docId)
	{
		$db = JFactory::getDBO();
		$query = "SELECT category FROM #__digitalmarketx_documents WHERE id = " . (int)$docId;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	static public function recalculateDocumentRating($docId)
	{
		$db = JFactory::getDBO();
		$db->setQuery("START TRANSACTION");
		$query = "SELECT SUM(stars) AS total_stars, SUM(thumbs_up) AS total_thumbs_up, SUM(thumbs_down) AS total_thumbs_down,
			COUNT(*) AS total FROM #__digitalmarketx_votes WHERE state = 1 AND document_id = " . (int)$docId;
		$db->setQuery( $query );
		$total = $db->loadObject();
		if($total && $total->total > 0)
		{
			$stars = (int)$total->total_stars ;
			$up = (int)$total->total_thumbs_up;
			$down = (int)$total->thumbs_down;
			$count = (int)$total->total;
			$rating = $stars / (float)$count;
		}
		else
		{
			$rating = $stars = $up = $down = $count = 0;
		}
		$query = "UPDATE #__digitalmarketx_documents 
			SET rating = $rating, rating_count = $count, thumbs_up = $up, thumbs_down = $down
			WHERE id = " . (int)$docId;
		$db->setQuery( $query );
		$db->query();
		$db->setQuery("COMMIT TRANSACTION");
	}
	
	static public function notifyVoteApproved($document_id, $document_title, $owner)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$notification_subject = $params->get('comment_approved_subject', '');
		$notificationbody = $params->get('comment_approved_body', '');
		$notification_subject = DigitalMarketXHelper::_doVoteEmailReplacements($document_id, $document_title, $notification_subject);
		$notificationbody = DigitalMarketXHelper::_doVoteEmailReplacements($document_id, $document_title, $notificationbody);
		$user = JFactory::getUser($owner);
		if(!$user || !$user->id)
			return false;
		$mail = JFactory::getMailer();
		$mail->setSubject($notification_subject);
		$mail->setBody($notificationbody);
		$mail->clearAddresses();
		$mail->addRecipient($user->email);
		$joomla_config = new JConfig();
		$mail->IsHTML(true);
		$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
		DigitalMarketXHelper::debug("Sending email $notification_subject, $notificationbody to " . $user->email);
		return $mail->send();
	}
	
	static public function notifyCommentSubmitted($document_id, $document_title)
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$notification_email = $params->get('notification_email', '');
		if($notification_email)
		{
			$notification_subject = $params->get('new_comment_subject', '');
			$notificationbody = $params->get('new_comment_body', '');
			$notification_subject = DigitalMarketXHelper::_doVoteEmailReplacements($document_id, $document_title, $notification_subject);
			$notificationbody = DigitalMarketXHelper::_doVoteEmailReplacements($document_id, $document_title, $notificationbody);
			
			$mail = JFactory::getMailer();
			$mail->setSubject($notification_subject);
			$mail->setBody($notificationbody);
			$emails = explode(';', $notification_email);
			$mail->clearAddresses();
			foreach($emails as $addr)
			{
				$mail->addRecipient($addr);
			}
			$mail->IsHTML(true);
			$joomla_config = new JConfig();
			$mail->setSender(array($joomla_config->mailfrom, $joomla_config->fromname));
			DigitalMarketXHelper::debug("Sending email $notification_subject, $notificationbody to " . $notification_email);
			return $mail->send();
		}
		return false;
	}
	
	
	static private function _doVoteEmailReplacements($document_id, $document_title, $text)
	{
		$text = preg_replace('/{document}/', '"' . $document_title . '"', $text);
		$link = JUri::root() . "index.php?option=com_digitalmarketx&view=details&id=" . $document_id;
		$text = preg_replace("/{link}/", $link, $text);
		return $text;
	}
	
	static private function debug($text)
	{
		/*$db = JFactory::getDBO();
		$db->setQuery("INSERT INTO debug(text, time) VALUES('" . $db->escape($text) . "', NOW())");
		$db->query();*/
	}
}
