<?php
/**
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * DigitalMarketX model.
 */
class DigitalMarketXModeldocument extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_DIGITALMARKETX';
	
	public function __construct($config = array()) {
	    //Ininitial event for action on document
        if (!isset($config['event_after_delete'])) {
            $config['event_after_delete'] = 'onDocumentAfterDelete' ;
        }	        
	    if (!isset($config['event_after_save'])) {
            $config['event_after_save'] = 'onDocumentAfterSave' ;
        }        
	    if (!isset($config['event_before_delete'])) {
            $config['event_before_delete'] = 'onDocumentBeforeDelete' ;
        }        
	    if (!isset($config['event_before_save'])) {
            $config['event_before_save'] = 'onDocumentBeforeSave' ;
        }
	    if (!isset($config['event_change_state'])) {
            $config['event_change_state'] = 'onDocumentChangeState' ;
        }
        
        parent::__construct($config) ;
	}

	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'Document', $prefix = 'DigitalMarketXTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		An optional array of data for the form to interogate.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	JForm	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_digitalmarketx.document', 'document', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}

		return $form;
	}
	
	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_digitalmarketx.edit.document.data', array());
		if (empty($data)) {
			$data = $this->getItem();
		}
		return $data;
	}

	/**
	 * Method to get a single record.
	 *
	 * @param	integer	The id of the primary key.
	 *
	 * @return	mixed	Object on success, false on failure.
	 * @since	1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk)) {

			//Do any procesing on fields here if needed
			if($pk == null)
				$pk = $this->getState('document.id');
			$db = JFactory::getDBO();
			$query = "SELECT #__digitalmarketx_documents_users.user_id, #__users.name FROM #__digitalmarketx_documents_users 
				LEFT JOIN #__users ON #__digitalmarketx_documents_users.user_id = #__users.id
				WHERE #__digitalmarketx_documents_users.doc_id = " . (int)$pk;
			$db->setQuery( $query );
			$item->users = $db->loadObjectList();
		}

		return $item;
	}

	/**
	 * Prepare and sanitise the table prior to saving.
	 *
	 * @since	1.6
	 */
	protected function prepareTable($table)
	{
		jimport('joomla.filter.output');

		if (empty($table->id)) {

			// Set ordering to the last item if not set
			if (@$table->ordering === '') {
				$db = JFactory::getDbo();
				$db->setQuery('SELECT MAX(ordering) FROM #__digitalmarketx_documents');
				$max = $db->loadResult();
				$table->ordering = $max+1;
			}
		}
	}
	
	/**
	 * Method to test whether a record can be deleted.
	 *
	 * @param	object	$record	A record object.
	 *
	 * @return	boolean	True if allowed to delete the record. Defaults to the permission set in the component.
	 * @since	1.6
	 */
	protected function canDelete($record)
	{
		if (!empty($record->id)) {
			if ($record->state != -2) {
				return ;
			}
			$user = JFactory::getUser();
			if (!empty($record->category)) {
				return $user->authorise('core.delete', 'com_digitalmarketx.category.'.(int) $record->category);
			}
		}
	}
	
	/**
	 * Method to test whether a record can have its state edited.
	 *
	 * @param	object	$record	A record object.
	 *
	 * @return	boolean	True if allowed to change the state of the record. Defaults to the permission set in the component.
	 * @since	1.6
	 */
	protected function canEditState($record)
	{
		$user = JFactory::getUser();

		// New item, so check against the category.
		if (!empty($record->category)) {
			return $user->authorise('core.edit.state', 'com_digitalmarketx.category.'.(int) $record->category);
		}
		// Default to component settings if neither item nor category known.
		else {
			return parent::canEditState('com_digitalmarketx');
		}
	}
	
	private function allowEditStateInCategory($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('core.edit.state', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	private function allowAddToCategory($category)
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.upload', 'com_digitalmarketx.category.'.(int) $category);
	}
	
	private function isAllowedExtension($filename, $allowed = null)
	{
		$ext = "";
		$dotpos = strrpos($filename, ".");
		if($dotpos !== false)
		{
			$ext = substr($filename, $dotpos + 1);
			$ext = trim(strtolower($ext));
		}
		$params = JComponentHelper::getParams('com_digitalmarketx');
		if($allowed == null)
			$allowed = $params->get("alloweduploadfiletypes", "pdf ppt gz tar tgz zip bmp gif jpeg jpg jpe png tiff tif txt mpeg mpg mpe qt mov avi flv doc docx");
		$allowed_ext = explode(" ", $allowed);
		foreach($allowed_ext as $e)
		{
			if($ext == trim(strtolower($e)))
				return true;
		}
		return false;
	}
	
	private function createImageThumb($image)
	{
		if(function_exists("getimagesize"))
		{
			$img = null;
			$size = getimagesize($image);
			switch($size[2])
			{
			case 1: //gif
				$img = imagecreatefromgif($image);
				break;
			case 2: //jpg
				$img = imagecreatefromjpeg($image);
				break;
			case 3: //png
				$img = imagecreatefrompng($image);
				break;
			case 6: //bmp
				$img = imagecreatefromwbmp($image);
				break;
			default: 
				return false;
			}
			$nw = $width = (int)$size[0];
			$nh = $height = (int)$size[1];
			$startx = 0;
			$starty = 0;
			if($width > $height)
			{
				$nw = 150;
				$nh = ($height * $nw) / $width;
				$starty = (150 - $nh) / 2;
			}
			else
			{
				$nh = 150;
				$nw = ($nh * $width) / $height;
				$startx = (150 - $nw) / 2;
			}
			$dest = imagecreatetruecolor(150, 150);
			$background = imagecolorallocate($dest, 255, 13, 252);
			imagecolortransparent ($dest, $background);
			imagefilledrectangle($dest, 0, 0, 149, 149, $background);
			imagecopyresized($dest, $img, $startx, $starty, 0, 0, $nw, $nh, $width, $height);
			imagepng($dest, $image . "_small.jpg");
			imagedestroy($img);
			imagedestroy($dest);
		}
	}
	
	private function randomizeFileName($filename)
	{
		$ext = "";
		$dotpos = strrpos($filename, ".");
		if($dotpos !== false)
		{
			$ext = substr($filename, $dotpos + 1);
			$filename = substr($filename, 0, $dotpos);
		}
		for($i = 0; $i < 10; $i++)
			$filename .= rand(0, 9);
		return $filename . "." . $ext;
	}
	
	private function uploadImage($dest_folder, $input, &$data, $required, $errorMsg, $allowedExtensions = null)
	{
		jimport('joomla.filesystem.file');
		if(JRequest::getInt("jform_" . $input . "_remove"))
		{
			$data[$input] = '';
			return true;
		}
		if($_FILES['jform']['name'][$input])
		{
			if (is_uploaded_file($_FILES['jform']['tmp_name'][$input]))
			{
				$fileName = JFile::makeSafe($_FILES['jform']['name'][$input]);
				$fileName = $this->randomizeFileName($fileName);
				if($this->isAllowedExtension($fileName, $allowedExtensions))
				{
					if(!JFile::upload($_FILES['jform']['tmp_name'][$input], 
						JPATH_ROOT . "/" . $dest_folder . "/" . $fileName))
					{
						$this->setError(JText::_('COM_DIGITALMARKETX_NO_FILE_UPLOADED'));
						return false ;
					}
					$data[$input] = $dest_folder . "/" . $fileName;
					$this->createImageThumb(JPATH_ROOT . "/" . $data[$input]);
				}
				else
				{
					$this->setError($errorMsg);
					return false ;
				}
			}
			else if($required)
			{
				$this->setError(JText::_('COM_DIGITALMARKETX_NO_FILE_UPLOADED'));
				return false ;
			}
		}
		return true;
	}
	
	private function getFolderForUser($dest_folder)
	{
		jimport('joomla.filesystem.file');
		jimport('joomla.filesystem.folder');
		$user_id = (int)JFactory::getUser()->id;
		$folder = JPATH_ROOT . "/" . $dest_folder . "/" . $user_id;
		if(!JFolder::exists($folder))
		{
			JFolder::create($folder);
		}
		if(!JFile::exists($folder . "/index.html"))
		{
			JFile::copy(JPATH_ADMINISTRATOR . "/components/com_digitalmarketx/index.html",  $folder . "/index.html");
		}
		if(!JFile::exists($folder . "/.htaccess"))
		{
			JFile::copy(JPATH_ADMINISTRATOR . "/components/com_digitalmarketx/htaccess.txt",  $folder . "/.htaccess");
		}
		if(JFolder::exists($folder))
		{
			return $dest_folder . "/" . $user_id;
		}
		else
			return $dest_folder;
	}
	
	private function uploadFile($dest_folder, $input, &$data, $required, $errorMsg, $allowedExtensions = null)
	{
		jimport('joomla.filesystem.file');
		if(JRequest::getInt("jform_" . $input . "_remove"))
		{
			$data[$input] = '';
			return true;
		}
		if($_FILES['jform']['name'][$input])
		{
			if (is_uploaded_file($_FILES['jform']['tmp_name'][$input]))
			{
				$fileName = JFile::makeSafe($_FILES['jform']['name'][$input]);
				$dest_folder = $this->getFolderForUser($dest_folder);
				if($this->isAllowedExtension($fileName, $allowedExtensions))
				{
					$params = JComponentHelper::getParams('com_digitalmarketx');
					$allow_unsafe = $params->get("allow_unsafe", 0);
					if($allow_unsafe)
						$uploaded = JFile::upload($_FILES['jform']['tmp_name'][$input], 
							JPATH_ROOT . "/" . $dest_folder . "/" . $fileName,
							false, $allow_unsafe);
					else
						$uploaded = JFile::upload($_FILES['jform']['tmp_name'][$input], 
							JPATH_ROOT . "/" . $dest_folder . "/" . $fileName);
					if(!$uploaded)
					{
						$this->setError(JText::_('COM_DIGITALMARKETX_NO_FILE_UPLOADED'));
						return false ;
					}
					$data[$input] = $dest_folder . "/" . $fileName;
				}
				else
				{
					$this->setError($errorMsg);
					return false ;
				}
			}
			else if($required)
			{
				$this->setError(JText::_('COM_DIGITALMARKETX_NO_FILE_UPLOADED'));
				return false ;
			}
		}
		return true;
	}
	
	public function save($data)
	{
		require_once(JPATH_COMPONENT . DS .  "helpers" . DS .  "digitalmarketx.php");
		jimport('joomla.filesystem.file') ;
		$is_new = false;
		$id = $data['id'];
		$prev_state = DigitalMarketXHelper::getDocumentState($id);
		$prev_category = DigitalMarketXHelper::getDocumentCategory($id);
		$category = $data['category'];
		if(!empty($category))
		{
			if(!$this->allowAddToCategory($category))
			{
				$data['category'] = null;
			}
		}
		if(!$this->allowEditStateInCategory($category))
		{
			$data['state'] = null;
		}
		if(empty($id))
		{
			$is_new = true;
			if (!$_FILES['jform']['name']['attachment']) 
			{
				$this->setError(JText::_('COM_DIGITALMARKETX_NO_FILE_UPLOADED'));
				return false ;
			}
		} 
		if($data['alias'] == '')
			$data['alias'] = $this->generateAlias($data['title']);
		if(!$this->uploadFile("digitalmarketxdocs", 'attachment', $data, true, JText::_('COM_DIGITALMARKETX_EXTENSION_NOT_ALLOWED')))
			return false;
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$allowedExtensions = $params->get('alloweduploadimagetypes', "bmp gif jpeg jpg jpe png");
		$this->uploadImage("digitalmarketxthumb", 'thumbnail', $data, false, JText::_('COM_DIGITALMARKETX_EXTENSION_NOT_ALLOWED_THUMB'), $allowedExtensions);
		$this->uploadFile("digitalmarketxdocs", 'demo_file', $data, false, JText::_('COM_DIGITALMARKETX_EXTENSION_NOT_ALLOWED'));
		
		$user = JFactory::getUser();
		if(empty($id) && !isset($data["created_user_id"]) && $user->id)
		{
			$data["created_user_id"] = $user->id;
		}
		if(empty($id))
		{
			$date = new JDate();
			$date = $date->toSql();
			$data["created_time"] = $date;
		}
		$result = parent::save($data);
		$id = $this->getState('document.id');
		$this->saveDocumentUsers($id, $data['users']);
		$new_state = DigitalMarketXHelper::getDocumentState($id);
		if(!$is_new && $result && $new_state != $prev_state)
		{
			DigitalMarketXHelper::notifyStateChange($id, $data['title'], $data['state'], $data['users']);
		}
		else if($is_new && $result)
		{
			DigitalMarketXHelper::notifyUpload($id, $data['title'], $data['users']);
		}
		return $result;
	}
	
	private function saveDocumentUsers($docId, $users)
	{
		$docId = (int)$docId;
		$db = JFactory::getDBO();
		$query = "DELETE FROM #__digitalmarketx_documents_users WHERE doc_id = " . $docId;
		$db->setQuery( $query );
		$db->query();
		$users = explode(",", $users);
		foreach($users as $user)
		{
			$user = (int)$user;
			if($user)
			{
				$query = "INSERT INTO #__digitalmarketx_documents_users(doc_id, user_id) VALUES($docId, $user)";
				$db->setQuery( $query );
				$db->query();
			}
		}
	}

	private function generateAlias($title)
	{
		$alias = $title;
		$alias = preg_replace("//", "a", $alias);
		$alias = preg_replace("//", "e", $alias);
		$alias = preg_replace("//", "i", $alias);
		$alias = preg_replace("//", "o", $alias);
		$alias = preg_replace("//", "u", $alias);
		$alias = preg_replace("//", "A", $alias);
		$alias = preg_replace("//", "E", $alias);
		$alias = preg_replace("//", "I", $alias);
		$alias = preg_replace("//", "O", $alias);
		$alias = preg_replace("//", "U", $alias);
		$alias = preg_replace("//", "n", $alias);
		$alias = preg_replace("//", "N", $alias);
		$alias = preg_replace("/\./", "_", $alias);
		$alias = preg_replace("/\\s/", "_", $alias);
		return $alias;
	}
	
	public function publish(&$cid, $value = 1)
	{
		require_once(JPATH_COMPONENT . DS . "helpers" . DS . "digitalmarketx.php");
		$result = parent::publish($cid, $value);
		if(count($cid) > 0)
		{
			$cids = implode(",", $cid);
			$db = JFactory::getDBO();
			$query = "SELECT id, title, state FROM #__digitalmarketx_documents WHERE id IN ($cids)";
			$db->setQuery( $query );
			$docs = $db->loadObjectList();
			foreach($docs as $doc)
			{
				DigitalMarketXHelper::notifyStateChange($doc->id, $doc->title, $doc->state, $this->getUsers($doc->id));
			}
		}
		return $result;
	}
	
	private function getUsers($id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT #__digitalmarketx_documents_users.user_id FROM #__digitalmarketx_documents_users 
			WHERE #__digitalmarketx_documents_users.doc_id = " . (int)$id;
		$db->setQuery( $query );
		return $db->loadObjectList();
	}
}