<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * DigitalMarketX model.
 */
class DigitalMarketXModeldownloadlink extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_DIGITALMARKETX';
	
	public function __construct($config = array()) {
	    //Ininitial event for action on document
        if (!isset($config['event_after_delete'])) {
            $config['event_after_delete'] = 'onDocumentAfterDelete' ;
        }	        
	    if (!isset($config['event_after_save'])) {
            $config['event_after_save'] = 'onDocumentAfterSave' ;
        }        
	    if (!isset($config['event_before_delete'])) {
            $config['event_before_delete'] = 'onDocumentBeforeDelete' ;
        }        
	    if (!isset($config['event_before_save'])) {
            $config['event_before_save'] = 'onDocumentBeforeSave' ;
        }
	    if (!isset($config['event_change_state'])) {
            $config['event_change_state'] = 'onDocumentChangeState' ;
        }
        
        parent::__construct($config) ;
	}

	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'Downloadlink', $prefix = 'DigitalMarketXTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		An optional array of data for the form to interogate.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	JForm	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_digitalmarketx.downloadlink', 'downloadlink', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}

		return $form;
	}
	
	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_digitalmarketx.edit.downloadlink.data', array());
		if (empty($data)) {
			$data = $this->getItem();
		}
		return $data;
	}

	/**
	 * Method to get a single record.
	 *
	 * @param	integer	The id of the primary key.
	 *
	 * @return	mixed	Object on success, false on failure.
	 * @since	1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk)) {

			//Do any procesing on fields here if needed

		}

		return $item;
	}

	/**
	 * Prepare and sanitise the table prior to saving.
	 *
	 * @since	1.6
	 */
	protected function prepareTable($table)
	{
		jimport('joomla.filter.output');

		if (empty($table->download_id)) {

			// Set ordering to the last item if not set
			if (@$table->ordering === '') {
				$db = JFactory::getDbo();
				$db->setQuery('SELECT MAX(ordering) FROM #__digitalmarketx_downloadlinks');
				$max = $db->loadResult();
				$table->ordering = $max+1;
			}
		}
	}
	
	function createDownloadLink($item_id, $email)
	{
		$item_id = (int)$item_id;
		$db = JFactory::getDBO();
		//Delete expired and not paid download links 
		$db->setQuery("DELETE FROM #__digitalmarketx_download_links WHERE expiration_date < NOW() || (paid = 0 AND TO_DAYS(NOW()) - TO_DAYS(creation_date) > 1)");
		$db->query();
		
		$secret_word = $this->getRandom($item_id . $item_id);
		$random_value = $this->getRandom($item_id);
		
		$e_secret_word = $db->escape($secret_word);
		$e_random_value = $db->escape($random_value);
		$email = $db->escape($email);
		
		$query = "INSERT INTO #__digitalmarketx_download_links
			(item_id, paid, creation_date, secret_word, random_value, link_max_downloads, expiration_date, payer_email)
			VALUES($item_id, 1, NOW(), '$e_secret_word', '$e_random_value', 100, DATE_ADD(NOW(), INTERVAL 100 DAY), '$email')";
		$db->setQuery($query);
		$db->query();
		$download_id = (int)$db->insertid();
		$downloadLink = new stdClass();
		if($downloadLink)
		{
			$downloadLink->downloadId = $download_id;
			$downloadLink->secret_word = $secret_word;
			$downloadLink->random_value = $random_value;
			$downloadLink->accessCode = $download_id . ":" . sha1($secret_word . $random_value) . 
				":" . $random_value;
		}
		$config = $this->_getConfig();
		if($config)
		{
			$download_url = $this->_getDownloadUrl($item_id, $downloadLink->accessCode);
			$config->client_notification_subject = 
				$this->_doTextReplacements($config->client_notification_subject, $download_url);
			$config->client_notificationbody = 
				$this->_doTextReplacements($config->client_notificationbody, $download_url);
			$db = JFactory::getDBO();
			$subject = $db->escape($config->client_notification_subject);
			$body = $db->escape($config->client_notificationbody);
			$download_url = $db->escape($download_url);
			$query = "UPDATE #__digitalmarketx_download_links SET subject='$subject', emailbody='$body',
				 	download_link = '$download_url'
				WHERE download_id = " . (int)$download_id;
			$db->setQuery( $query );
			$db->query();
		}
		return $downloadLink;
	}
	
	function getRandom($seed)
	{
		$config = JFactory::getConfig();
		$secret = "";
		$version = new JVersion();
		if($config)
		{
			if($version->RELEASE < "3.0")
				$secret .= $config->getValue( 'config.secret' ) . $config->getValue( 'config.password' );
			else
				$secret .= $config->get( 'config.secret' ) . $config->get( 'config.password' );
		}
		$rand = $seed;
		for($i = 0; $i < 100; $i++)
		{
			$rand .= microtime() . $secret . mt_rand();
			$rand = sha1($rand);
		}
		return $rand;
	}
	
	function _getDownloadUrl($item_id, $accesscode)
	{
		$db = JFactory::getDBO();
		$query = "SELECT category FROM #__digitalmarketx_documents WHERE id = " . (int)$item_id;
		$db->setQuery( $query );
		$category = $db->loadResult();
		$url = JURI::base();
		$url .= "index.php?option=com_digitalmarketx&view=category&id=" . (int)$category;
		$url .= "&digitalmarketxaccesscode=" . urlencode($accesscode);
		return $url;
	}
	
	function _doTextReplacements($text, $download_link)
	{
		$text = preg_replace("/{download_link}/", $download_link, $text);
		return $text;
	}
	
	function _getConfig()
	{
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$config = new stdclass();
		$config->client_notification_subject = $params->get('client_notification_subject', JText::_("COM_DIGITALMARKETX_CLIENT_DEFAULT_NOTIFICATION_SUBJECT"));
		$config->client_notificationbody = $params->get('client_notificationbody', JText::_("COM_DIGITALMARKETX_CLIENT_DEFAULT_NOTIFICATION_BODY"));
		return $config;
	}
	
	
}