<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

defined('JPATH_BASE') or die;

/**
 * Supports an HTML select list of categories
 */
class JFormFieldFileupload extends JFormField
{
	public $type = 'fileupload';
	
	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// Initialize some field attributes.
		$accept = $this->element['accept'] ? ' accept="' . (string) $this->element['accept'] . '"' : '';
		$size = $this->element['size'] ? ' size="' . (int) $this->element['size'] . '"' : '';
		$class = $this->element['class'] ? ' class="' . (string) $this->element['class'] . '"' : '';
		$disabled = ((string) $this->element['disabled'] == 'true') ? ' disabled="disabled"' : '';

		// Initialize JavaScript field attributes.
		$onchange = $this->element['onchange'] ? ' onchange="' . (string) $this->element['onchange'] . '"' : '';
		
		$html = htmlspecialchars($this->value);
		if($this->element['allowdelete'] && $this->value)
		{
			$html .= '<div style="float: right;">';
			$html .= htmlspecialchars(JText::_("COM_DIGITALMARKETX_REMOVE")) . 
				'&nbsp;&nbsp;&nbsp;<input type="checkbox" name="' . $this->id . '_remove" value="1" />'. "</div>";
			
		}
		$html .= "<br/>";
		$html .= '<input type="file" name="' . $this->name . '" id="' . $this->id . '"' . ' value=""' . $accept . $disabled . $class . $size
			. $onchange . ' />';
		return $html;
	}
	
}
?>