<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

/**
 * Supports an HTML select list of categories
 */
class JFormFieldForeign extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'foreign';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// Initialize variables.
		$html = "<select name=\"" . $this->name . "\" id=\"" . $this->name . "\">";
		if($this->element["firstitem"])
		{
			$html .= "<option value=\"\">" . htmlspecialchars(JText::_($this->element["firstitem"])) . "</option>";
		}
		$table = $this->element["table"];
		$key = $this->element["key"];
		$display = $this->element["display"];
		$db = JFactory::getDBO();
		$query = "SELECT " . $key . ", " . 
			$display . " FROM " . 
			$table;
		$db->setQuery($query);
		$list = $db->loadObjectList();
		if($list)
		{
			foreach($list as $item)
			{
				$selected = ($item->$key == $this->value) ? "selected" : "";
				$html .= "<option value=\"" . htmlspecialchars($item->$key) . "\" $selected>";
				$html .= htmlspecialchars($item->$display);
				$html .= "</option>";
			}
		}
		$html .= "</select>";
		return $html;
	}
}