<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

/**
 * Supports an HTML select list of categories
 */
class JFormFieldReadOnlyForeign extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'readonlyforeign';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// Initialize variables.
		$html = "";
		$table = $this->element["table"];
		$key = $this->element["key"];
		$display = $this->element["display"];
		$db = JFactory::getDBO();
		$query = "SELECT " . $key . ", " . 
			$display . " FROM " . 
			$table . 
			" WHERE " . $key . " = '" . 
			$db->escape($this->value) . "'";
		$db->setQuery($query);
		$result = $db->loadObject();
		if($result)
		{
			$html = "<input type=\"text\" " . 
				"name=\"" . $this->name . "\" " . 
				"id=\"" . $this->name . "\" " . 
				"value=\"" . htmlspecialchars($result->$display) . "\" class=\"readonly\" " . 
				"readonly=\"readonly\"/>";
		}
		return $html;
	}
}