<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

/**
 * Supports an HTML select list of categories
 */
class JFormFieldReportStats extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'reportstats';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// Initialize variables.
		$html = "";
		$doc_title = $this->getDocTitle($this->value);
		if($doc_title)
		{
			$html = "&quot;<a href=\"index.php?option=com_digitalmarketx&view=document&layout=edit&id=" . 
				(int)$this->value . "\" target=\"blank\">" . htmlspecialchars($doc_title) . "</a>&quot;";
			$html .= "&nbsp;";
			$html .= JText::_("COM_DIGITALMARKETX_USER_PROFIT");
			$html .= "&nbsp;(&nbsp;";
			$stats = $this->getDocStats($this->value);
			if($stats && count($stats) > 0)
			{
				$money = array();
				foreach($stats as $stat)
				{
					$money []= (float)$stat->total . "&nbsp;" . $stat->currency;
				}
				$html .= implode("&nbsp;,&nbsp;", $money);
			}
			else
				$html .= "0";
			$html .= "&nbsp;)&nbsp;";
		}
		return $html;
	}
	
	private function getDocTitle($doc_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT id, title FROM #__digitalmarketx_documents 
			WHERE id = " . (int)$doc_id;
		$db->setQuery( $query );
		$doc = $db->loadObject();
		if($doc)
			return $doc->title;
		return "";
	}
	
	private function getDocStats($doc_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT SUM(amount) AS total, currency 
			FROM #__digitalmarketx_documents_sales
			WHERE amount > 0 AND doc_id = " . (int)$doc_id . 
			" GROUP BY currency";
		$db->setQuery($query);
		$profit = $db->loadObjectList();
		return $profit;
	}
	
}