<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

/**
 * Supports an HTML select list of categories
 */
class JFormFieldUsers extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'users';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		//JHTML::_('behavior.mootools'); 
		JHTML::_('behavior.modal');
		$option = JRequest::getVar('option');
		VersionLayer::script('users.js', 'administrator/components/'. $option . '/js/');
		VersionLayer::script('users.css', 'administrator/components/'. $option . '/assets/css/');
		$html = "";
		$html .= "<div class=\"fltlft\">";
		$html .= '<input type="hidden" name="' . $this->name. '" id="' . $this->id . '_userids" value="' . 
			$this->getHiddenValue($this->value) . '"/>';
		$html .= '<div id="' . $this->id . '_usernames" class="dmuserbox">' . $this->getUserNames($this->value, $this->id) . '</div>';
		$html .= "</div>";
		$html .= "<div class=\"button2-left\">";
		$html .= "<div class=\"blank\">";
		$html .= "<a class=\"modal\" title=\"" . htmlspecialchars(JText::_("COM_DIGITALMARKETX_SELECT_USERS")) . "\" href=\"index.php?option=com_digitalmarketx&view=jusers&layout=modal&tmpl=component&field=" . $this->id . "\" rel=\"{handler: 'iframe', size: {x: 800, y: 500}}\">";
		$html .= htmlspecialchars(JText::_("COM_DIGITALMARKETX_SELECT_USERS")) . "</a>";
		$html .= "</div>";
		$html .= "</div>";
		return $html;
	}
	
	private function getHiddenValue($value)
	{
		$result = "";
		if(isset($value) && $value)
		{
			foreach($value as $user)
			{
				if($result != "")
					$result .= ",";
				$result .= $user->user_id;
			}
		}
		return $result;
	}
	
	private function getUserNames($value, $name)
	{
		$result = "";
		if(isset($value) && $value)
		{
			foreach($value as $user)
			{
				$result .= "<div id=\"userli_" . (int)$user->user_id . "\" style=\"float: left;\"><span>";
				$result .= htmlspecialchars($user->name) . "</span>";
				$result .= "<input type=\"button\" value=\"x\" style=\"float: right;\" onclick=\"removeUser('";
				$result .= addslashes($name) . "', '" . addslashes($user->user_id) . "');\"/>";
				$result .= "</div>";
			}
		}
		return $result;
	}
}