<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * Digitalmarketx model.
 */
class DigitalmarketXModelreport extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_DIGITALMARKETX';


	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'Report', $prefix = 'DigitalmarketxTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		An optional array of data for the form to interogate.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	JForm	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_digitalmarketx.report', 'report', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_digitalmarketx.edit.vote.data', array());

		if (empty($data)) {
			$data = $this->getItem();
            
		}

		return $data;
	}

	/**
	 * Method to get a single record.
	 *
	 * @param	integer	The id of the primary key.
	 *
	 * @return	mixed	Object on success, false on failure.
	 * @since	1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk)) {

			//Do any procesing on fields here if needed

		}

		return $item;
	}

	public function proceedWithReport($report_id)
	{
		$doc_id = $this->getReportDoc($report_id);
		if($doc_id)
		{
			$this->disableDoc($doc_id);
			$this->deleteReport($report_id);
			$owner = $this->getDocOwner($doc_id);
			$stats = $this->getDocStats($doc_id);
			if($stats && count($stats) > 0)
			{
				foreach($stats as $stat)
				{
					$this->decreaseUserBalance($owner, 
						$stat->total, $stat->currency);
				}
			}
			$stats_per_buyer = $this->getDocStatsPerBuyer($doc_id);
			if($stats_per_buyer && count($stats_per_buyer) > 0)
			{
				foreach($stats_per_buyer as $stat)
				{
					$this->refundBuyer($stat->buyer_id, 
						$stat->total, $stat->currency);
				}
			}
			$this->removeDocStats($doc_id);
		}
	}
	
	private function removeDocStats($doc_id)
	{
		$db = JFactory::getDBO();
		$query = "DELETE FROM #__digitalmarketx_documents_sales
			WHERE doc_id = " . (int)$doc_id;
		$db->setQuery($query);
		$db->query();
	}
	
	private function addDecreaseToStat($doc_id, $amount, $currency)
	{
		$doc_id = (int)$doc_id;
		$amount = -1 * (float)$amount;
		$db = JFactory::getDBO();
		$currency = $db->escape($currency);
		$query = "INSERT INTO #__digitalmarketx_documents_sales
			(doc_id, amount, currency, purchase_time)
			VALUES($doc_id, $amount, '$currency', NOW())";
		$db->setQuery( $query );
		$db->query();
	}
	
	private function deleteReport($report_id)
	{
		$db = JFactory::getDBO();
		$query = "DELETE FROM #__digitalmarketx_documents_reports
			WHERE id = " . (int)$report_id;
		$db->setQuery( $query );
		$db->query();
	}
	
	private function getDocOwner($doc_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT created_user_id FROM #__digitalmarketx_documents 
			WHERE id = " . (int)$doc_id;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	private function refundBuyer($user_id, $amount, $currency, $doc_id)
	{
		$amount = (float)$amount;
		$user_id = (int)$user_id;
		$db = JFactory::getDBO();
		$currency = $db->escape($currency);
		$query = "SELECT money_id 
			FROM #__digitalmarketx_users_money 
			WHERE currency = '$currency' AND userid = " . $user_id;
		$db->setQuery($query);
		$money_id = (int)$db->loadResult();
		if($money_id)
		{
			$query = "UPDATE 
				#__digitalmarketx_users_money 
				SET balance = balance + $amount 
				WHERE money_id = $money_id";
		}
		else
		{
			$query = "INSERT INTO 
				#__digitalmarketx_users_money(userid, balance, currency) 
				VALUES($user_id, $amount, '$currency')";
		}
		$db->setQuery( $query );
		$db->query();
	}
	
	function saveSaleStat($document_id, $buyer_id, $amount, $currency)
	{
		$document_id = (int)$document_id;
		$buyer_id = (int)$buyer_id;
		$amount = (float)$amount;
		$date = new JDate();
		$date = $date->toSql();
		$db = JFactory::getDBO();
		$date = $db->escape($date);
		$currency = $db->escape($currency);
		$query = "INSERT INTO #__digitalmarketx_documents_sales
			(doc_id, buyer_id, amount, purchase_time, currency)
			VALUES($document_id, $buyer_id, $amount, '$date', '$currency')";
		$db->setQuery( $query );
		$db->query();
	}
	
	private function decreaseUserBalance($user_id, $amount, $currency)
	{
		$amount = (float)$amount;
		$user_id = (int)$user_id;
		$db = JFactory::getDBO();
		$currency = $db->escape($currency);
		$query = "SELECT * FROM #__digitalmarketx_users_money 
			WHERE currency = '$currency' AND userid = $user_id";
		$db->setQuery( $query );
		$money = $db->loadObject();
		if($money)
		{
			if($money->claimed >= $amount)
			{
				$query = "UPDATE #__digitalmarketx_users_money 
					SET claimed = claimed - $amount
					WHERE money_id = " . (int)$money->money_id;
				$db->setQuery( $query );
				$db->query();
			}
			else
			{
				if($money->claimed > 0)
				{
					$amount -= $money->claimed;
				}
				$query = "UPDATE #__digitalmarketx_users_money 
					SET balance = balance - $amount, claimed = 0
					WHERE money_id = " . (int)$money->money_id;
				$db->setQuery( $query );
				$db->query();
			}
		}
	}
	
	private function getReportDoc($report_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT doc_id FROM #__digitalmarketx_documents_reports
			WHERE id = " . (int)$report_id;
		$db->setQuery( $query );
		return $db->loadResult();
	}
	
	private function getDocStats($doc_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT SUM(amount) AS total, currency 
			FROM #__digitalmarketx_documents_sales
			WHERE amount > 0 AND doc_id = " . (int)$doc_id . 
			" GROUP BY currency";
		$db->setQuery($query);
		$profit = $db->loadObjectList();
		return $profit;
	}
	
	private function getDocStatsPerBuyer($doc_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT SUM(amount) AS total, currency, buyer_id 
			FROM #__digitalmarketx_documents_sales
			WHERE amount > 0 AND doc_id = " . (int)$doc_id . 
			" GROUP BY currency, buyer_id";
		$db->setQuery($query);
		$profit = $db->loadObjectList();
		return $profit;
	}
	
	private function disableDoc($doc_id)
	{
		$db = JFactory::getDBO();
		$query = "UPDATE #__digitalmarketx_documents SET state= -2 
			WHERE id = " . (int)$doc_id;
		$db->setQuery( $query );
		$db->query();
	}
}