<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * Digitalmarketx model.
 */
class DigitalmarketxModeltemplate extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_DIGITALMARKETX';


	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'Template', $prefix = 'DigitalmarketxTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		An optional array of data for the form to interogate.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	JForm	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_digitalmarketx.template', 'template', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_digitalmarketx.edit.template.data', array());

		if (empty($data)) {
			$data = $this->getItem();
            
		}

		return $data;
	}

	/**
	 * Method to get a single record.
	 *
	 * @param	integer	The id of the primary key.
	 *
	 * @return	mixed	Object on success, false on failure.
	 * @since	1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk)) {

			//Do any procesing on fields here if needed

		}

		return $item;
	}
	
	public function setDefault($id)
	{
		$db = JFactory::getDBO();
		$db->setQuery("UPDATE #__digitalmarketx_templates SET defaultTemplate = 0");
		$db->query();
		$db->setQuery("UPDATE #__digitalmarketx_templates SET defaultTemplate = 1 WHERE id = " . 
			(int)$id);
		$db->query();
	}

	/**
	 * Prepare and sanitise the table prior to saving.
	 *
	 * @since	1.6
	 */
	protected function prepareTable($table)
	{
		jimport('joomla.filter.output');

		if (empty($table->id)) {

			// Set ordering to the last item if not set
			if (@$table->ordering === '') {
				$db = JFactory::getDbo();
				$db->setQuery('SELECT MAX(ordering) FROM #__digitalmarketx_templates');
				$max = $db->loadResult();
				$table->ordering = $max+1;
			}

		}
	}
	
	protected function unpack($filename)
	{
		jimport('joomla.filesystem.file');
		jimport('joomla.filesystem.folder');
		jimport('joomla.filesystem.archive');
		jimport('joomla.filesystem.path');
		jimport('joomla.base.adapter');
		$tmpdir = uniqid('install_');
		// Clean the paths to use for archive extraction
		$extractdir = JPath::clean(dirname($filename) . '/' . $tmpdir);
		$archivename = JPath::clean($filename);
		// Do the unpacking of the archive
		$result = JArchive::extract($archivename, $extractdir);
		if ($result === false)
		{
			return false;
		}
		$retval = array();
		$retval['extractdir'] = $extractdir;
		$retval['packagefile'] = $archivename;
		return $retval;
	}
	
	public function importTemplate($file_input)
	{
		$userfile = JRequest::getVar($file_input, null, 'files', 'array');
		// If there is no uploaded file, we have a problem...
		if (!is_array($userfile)) {
			JError::raiseWarning('', JText::_('COM_DIGITALMARKETX_MSG_INSTALL_NO_FILE_SELECTED'));
			return false;
		}

		// Check if there was a problem uploading the file.
		if ($userfile['error'] || $userfile['size'] < 1) {
			JError::raiseWarning('', JText::_('COM_DIGITALMARKETX_MSG_INSTALL_WARNINSTALLUPLOADERROR'));
			return false;
		}
		$config		= JFactory::getConfig();
		$tmp_dest	= $config->get('tmp_path') . '/' . $userfile['name'];
		$tmp_src	= $userfile['tmp_name'];
		// Move uploaded file
		jimport('joomla.filesystem.file');
		$uploaded = JFile::upload($tmp_src, $tmp_dest);
		$extraction = self::unpack($tmp_dest);
		if($extraction === false)
		{
			JError::raiseWarning('', JText::_('COM_DIGITALMARKETX_MSG_INVALID_TEMPLATE_FILE'));
			return false;
		}
		$xmlfiles = JFolder::files($extraction['extractdir'], '\.xml$', 1, true);
		if (!count($xmlfiles))
		{
			JError::raiseWarning('', JText::_('COM_DIGITALMARKETX_ERROR_NOTFINDXMLSETUPFILE'));
			return false;
		}
		$xml = JFactory::getXML($xmlfiles[0]);
		if (!$xml || $xml->getName() != 'digitalmarket_template')
		{
			JError::raiseWarning('', JText::_('COM_DIGITALMARKETX_ERROR_INVALIDXMLSETUPFILE'));
			return false;
		}
		$name = "template";
		$list_layout = "";
		$details_layout = "";
		$styles = "";
		if(isset($xml->attributes()->name))
		{
			$name = $xml->attributes()->name;
		}
		$children = $xml->children();
		if(isset($children->list_layout) && isset($children->list_layout->attributes()->file))
		{
			$file = $children->list_layout->attributes()->file;
			$list_layout = @file_get_contents($extraction['extractdir'] . '/' . $file);
		}
		if(isset($children->details_layout) && isset($children->details_layout->attributes()->file))
		{
			$file = $children->details_layout->attributes()->file;
			$details_layout = @file_get_contents($extraction['extractdir'] . '/' . $file);
		}
		if(isset($children->vote_layout) && isset($children->vote_layout->attributes()->file))
		{
			$file = $children->vote_layout->attributes()->file;
			$vote_layout = @file_get_contents($extraction['extractdir'] . '/' . $file);
		}
		if(isset($children->styles) && isset($children->styles->attributes()->file))
		{
			$file = $children->styles->attributes()->file;
			$styles = @file_get_contents($extraction['extractdir'] . '/' . $file);
		}
		$db = JFactory::getDBO();
		$name = $db->escape($name);
		$list_layout = $db->escape($list_layout);
		$details_layout = $db->escape($details_layout);
		$vote_layout = $db->escape($vote_layout);
		$styles = $db->escape($styles);
		$query = "INSERT INTO #__digitalmarketx_templates(name, details_layout, category_layout, vote_layout, style) 
			VALUES('$name', '$details_layout', '$list_layout', '$vote_layout', '$styles')";
		$db->setQuery( $query );
		return $db->query();
	}
	
}