<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of DigitalMarketX records.
 */
class DigitalMarketXModelusers extends JModelList
{

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array())
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'userid', '#__digitalmarketx_users.userid',
                'name', '#__users.name',
                'paypalaccount', 'paypalaccount'
            );
        }

        parent::__construct($config);
    }


	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$published = $this->getUserStateFromRequest($this->context.'.filter.state', 'filter_published', '', 'string');
		$this->setState('filter.state', $published);
        
        
        
		// Load the parameters.
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('#__digitalmarketx_users.userid', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param	string		$id	A prefix for the store id.
	 * @return	string		A store id.
	 * @since	1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id.= ':' . $this->getState('filter.search');
		$id.= ':' . $this->getState('filter.state');

		return parent::getStoreId($id);
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return	JDatabaseQuery
	 * @since	1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'#__digitalmarketx_users.*'
			)
		);
		$query->from('#__digitalmarketx_users');


		// Join over the category 'category'
		$query->select('name');
		$query->join('LEFT', '#__users ON #__digitalmarketx_users.userid = #__users.id');

		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('#__digitalmarketx_users.userid = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
				$searchQuery = "";
                for($i = 0; $i < count($this->filter_fields); $i+=2)
				{
					$filter_field = $this->filter_fields[$i + 1];
					if($i > 0)	
						$searchQuery .= " OR ";
					$searchQuery .= $filter_field . " LIKE " . $search ;
				}
				$query->where("(" . $searchQuery . ")");
			}
		}
        
		// Add the list ordering clause.
        $orderCol	= $this->state->get('list.ordering');
        $orderDirn	= $this->state->get('list.direction');
        if ($orderCol && $orderDirn) {
            $query->order($db->escape($orderCol.' '.$orderDirn));
        }

		return $query;
	}
	
	function setMoneyForItems($items)
	{
		$db = JFactory::getDBO();
		foreach($items as $item)
		{
			$item->money = $this->getMoneyForUser($item->userid);
		}
	}
	
	public function getMoneyForUser($user_id)
	{
		$db = JFactory::getDBO();
		$query = "SELECT * FROM #__digitalmarketx_users_money WHERE userid = " . (int)$user_id;
		$db->setQuery( $query );
		return $db->loadObjectList();
	}
	
	public function updateMoney($money_id, $balance, $claimed)
	{
		$money_id = (int)$money_id;
		$balance = (float)$balance;
		$claimed = (float)$claimed;
		$db = JFactory::getDbo();
		if($balance > 0 || $claimed > 0)
		{
			$query = "UPDATE #__digitalmarketx_users_money 
				SET balance = $balance, claimed = $claimed
				WHERE money_id = $money_id";
		}
		else
		{
			$query = "DELETE FROM #__digitalmarketx_users_money
				WHERE money_id = $money_id";
		}
		$db->setQuery( $query );
		return $db->query();
	}
}
