<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * Digitalmarketx model.
 */
class DigitalmarketXModelvote extends JModelAdmin
{
	/**
	 * @var		string	The prefix to use with controller messages.
	 * @since	1.6
	 */
	protected $text_prefix = 'COM_DIGITALMARKETX';


	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'Vote', $prefix = 'DigitalmarketxTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		An optional array of data for the form to interogate.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	JForm	A JForm object on success, false on failure
	 * @since	1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Initialise variables.
		$app	= JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm('com_digitalmarketx.vote', 'vote', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form)) {
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return	mixed	The data for the form.
	 * @since	1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_digitalmarketx.edit.vote.data', array());

		if (empty($data)) {
			$data = $this->getItem();
            
		}

		return $data;
	}

	/**
	 * Method to get a single record.
	 *
	 * @param	integer	The id of the primary key.
	 *
	 * @return	mixed	Object on success, false on failure.
	 * @since	1.6
	 */
	public function getItem($pk = null)
	{
		if ($item = parent::getItem($pk)) {

			//Do any procesing on fields here if needed

		}

		return $item;
	}

	/**
	 * Prepare and sanitise the table prior to saving.
	 *
	 * @since	1.6
	 */
	protected function prepareTable($table)
	{
		jimport('joomla.filter.output');

		if (empty($table->id)) {

			// Set ordering to the last item if not set
			if (@$table->ordering === '') {
				$db = JFactory::getDbo();
				$db->setQuery('SELECT MAX(ordering) FROM #__digitalmarketx_votes');
				$max = $db->loadResult();
				$table->ordering = $max+1;
			}

		}
	}
	
	public function publish(&$cid, $value = 1)
	{
		require_once(JPATH_COMPONENT . DS . "helpers" . DS . "digitalmarketx.php");
		$result = parent::publish($cid, $value);
		if(count($cid) > 0)
		{
			$cids = implode(",", $cid);
			$db = JFactory::getDBO();
			$query = "SELECT document_id FROM #__digitalmarketx_votes WHERE id IN ($cids) GROUP BY document_id";
			$db->setQuery( $query );
			$docs = $db->loadObjectList();
			foreach($docs as $doc)
			{
				DigitalMarketXHelper::recalculateDocumentRating($doc->document_id);
			}
			if($value == 1)
			{
				$query = "SELECT #__digitalmarketx_documents.id, #__digitalmarketx_documents.title, #__digitalmarketx_documents.created_user_id 
					FROM #__digitalmarketx_votes 
					INNER JOIN #__digitalmarketx_documents ON #__digitalmarketx_votes.document_id = #__digitalmarketx_documents.id
					WHERE #__digitalmarketx_votes.state = 1 AND #__digitalmarketx_votes.id IN ($cids) 
					GROUP BY #__digitalmarketx_documents.id, 
						#__digitalmarketx_documents.title, 
						#__digitalmarketx_documents.created_user_id";
				$db->setQuery( $query );
				$docs = $db->loadObjectList();
				foreach($docs as $doc)
				{
					DigitalMarketXHelper::notifyVoteApproved($doc->id, $doc->title, $doc->created_user_id);
				}
			}
		}
		return $result;
	}
	
	public function delete(&$pks)
	{
		require_once(JPATH_COMPONENT . DS . "helpers" . DS . "digitalmarketx.php");
		$result = parent::delete($pks);
		if(count($pks) > 0)
		{
			$cids = implode(",", $pks);
			$db = JFactory::getDBO();
			$query = "SELECT document_id FROM #__digitalmarketx_votes WHERE id IN ($cids) GROUP BY document_id";
			$db->setQuery( $query );
			$docs = $db->loadObjectList();
			foreach($docs as $doc)
			{
				DigitalMarketXHelper::recalculateDocumentRating($doc->document_id);
			}
		}
		return $result;
	}

}