<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Digitalmarketx records.
 */
class DigitalmarketXModelvotes extends JModelList
{

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array())
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'id', 'a.id',
                'state', 'a.state',
                'comment_subject', 'a.comment_subject',
                'comment_text', 'a.comment_text',
                'stars', 'a.stars',
                'thumbs', 'a.thumbs',
                'date_voted', 'a.date_voted',
                'user_id', 'user_id.name',
            );
        }

        parent::__construct($config);
    }


	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$state = $this->getUserStateFromRequest($this->context . '.filter.state', 'filter_state', '', 'string');
		$this->setState('filter.state', $state);
        
		//Filtering user_id
		$this->setState('filter.user_id', $app->getUserStateFromRequest($this->context.'.filter.user_id', 'filter_user_id', '', 'string'));
        
		// Load the parameters.
		$params = JComponentHelper::getParams('com_digitalmarketx');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('a.comment_subject', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param	string		$id	A prefix for the store id.
	 * @return	string		A store id.
	 * @since	1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id.= ':' . $this->getState('filter.search');
		$id.= ':' . $this->getState('filter.state');

		return parent::getStoreId($id);
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return	JDatabaseQuery
	 * @since	1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db		= $this->getDbo();
		$query	= $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'a.*'
			)
		);
		$query->from('`#__digitalmarketx_votes` AS a');

		// Join over the document field 'document_id'
		$query->select('docs.title AS doc_title');
		$query->join('LEFT', '#__digitalmarketx_documents AS docs ON docs.id = a.document_id');
		// Join over the user field 'user_id'
		$query->select('user_id.name AS user_id');
		$query->join('LEFT', '#__users AS user_id ON user_id.id = a.user_id');


    // Filter by published state
    $published = $this->getState('filter.state');
    if (is_numeric($published)) {
        $query->where('a.state = '.(int) $published);
    } else if ($published === '') {
        $query->where('(a.state IN (0, 1))');
    }
    

		// Filter by search in title
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = '.(int) substr($search, 3));
			} else {
				$search = $db->Quote('%'.$db->escape($search, true).'%');
                $query->where('( a.comment_subject LIKE '.$search.'  OR  a.comment_text LIKE '.$search.' )');
			}
		}
        


		//Filtering date_voted
		$filter_date_voted_from = $this->state->get("filter.date_voted.from");
		if ($filter_date_voted_from) {
			$query->where("a.date_voted >= '".$db->escape($filter_date_voted_from)."'");
		}
		$filter_date_voted_to = $this->state->get("filter.date_voted.to");
		if ($filter_date_voted_to) {
			$query->where("a.date_voted <= '".$db->escape($filter_date_voted_to)."'");
		}

		//Filtering user_id
		$filter_user_id = $this->state->get("filter.user_id");
		if ($filter_user_id) {
			$query->where("a.user_id = '".$db->escape($filter_user_id)."'");
		}        
        
        
		// Add the list ordering clause.
        $orderCol	= $this->state->get('list.ordering');
        $orderDirn	= $this->state->get('list.direction');
        if ($orderCol && $orderDirn) {
            $query->order($db->escape($orderCol.' '.$orderDirn));
        }

		return $query;
	}
}
