DROP TABLE IF EXISTS `#__digitalmarketx_documents_sales`;
DROP TABLE IF EXISTS `#__digitalmarketx_documents_reports`;
DROP TABLE IF EXISTS `#__digitalmarketx_votes_replies`;
DROP TABLE IF EXISTS `#__digitalmarketx_votes`;
DROP TABLE IF EXISTS `#__digitalmarketx_documents_stats`;
DROP TABLE IF EXISTS `#__digitalmarketx_documents_users`;
DROP TABLE IF EXISTS `#__digitalmarketx_documents`;
DROP TABLE IF EXISTS `#__digitalmarketx_configs`;
DROP TABLE IF EXISTS `#__digitalmarketx_download_links`;
DROP TABLE IF EXISTS `#__digitalmarketx_payments`;
DROP TABLE IF EXISTS `#__digitalmarketx_users`;
DROP TABLE IF EXISTS `#__digitalmarketx_users_money`;
DROP TABLE IF EXISTS `#__digitalmarketx_shopping_cart_item`;
DROP TABLE IF EXISTS `#__digitalmarketx_shopping_carts`;
DROP TABLE IF EXISTS `#__digitalmarketx_currency_exchanges`;
DROP TABLE IF EXISTS `#__digitalmarketx_templates`;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_documents` (
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`title` VARCHAR(255)  NOT NULL ,
`alias` VARCHAR(255)  NULL ,
`price` decimal(11,2),
`currency` VARCHAR(25)  NOT NULL ,
`ordering` INT(11)  NOT NULL ,
`state` TINYINT(1)  NOT NULL DEFAULT '1',
`category` INT(11)  NOT NULL ,
`attachment` VARCHAR(255)  NOT NULL ,
`thumbnail` VARCHAR(255)  NOT NULL ,
`demo_file` VARCHAR(255) NULL ,
`demo_text` TEXT NULL,
`description` TEXT NOT NULL ,
`thumbs_up` INT(11)  DEFAULT 0 ,
`thumbs_down` INT(11)  DEFAULT 0 ,
`rating` decimal(11,2) DEFAULT 0,
`rating_count` INT(11)  DEFAULT 0 ,
`metatags` VARCHAR(255)  NULL ,
`metadescription` VARCHAR(255)  NULL ,
`created_user_id` INT(11) NULL,
`created_time` DATETIME NULL,
`download_count` INT(11) NOT NULL DEFAULT 0,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_currency_exchanges` (
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`source_currency` VARCHAR(5) NOT NULL,
`dest_currency` VARCHAR(5) NOT NULL,
`rate` decimal(11,6),
`update_time` datetime NULL,
PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_documents_users` (
`doc_id` int(11) UNSIGNED NOT NULL,
`user_id` int(11) UNSIGNED NOT NULL,
PRIMARY KEY (`doc_id`, user_id)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_documents_users`
	ADD CONSTRAINT `#__digitalmarketx_documents_users_ibfk_1` FOREIGN KEY (`doc_id`) 
		REFERENCES `#__digitalmarketx_documents` (`id`) ON DELETE CASCADE;	  
	

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_download_links` (
  `download_id` int(11) NOT NULL auto_increment,	
  `item_id` int(11) NOT NULL,
  `secret_word` varchar(128) NOT NULL,
  `random_value` varchar(128) NOT NULL,
  `download_link` varchar(512) NOT NULL,
  `user_ip` varchar(128) NOT NULL,
  `payer_email` varchar(256) NOT NULL,
  `expiration_date` datetime NULL,
  `creation_date` datetime NULL,
  `download_hits` int(11) DEFAULT '0',
  `link_max_downloads` int(11) DEFAULT '0',
  `price` decimal(11,2) NOT NULL DEFAULT '0',
  `currency` varchar(128) NOT NULL,
  `user_id` int(11) DEFAULT '0',
  `paid` int(11) NOT NULL DEFAULT '0',
  `subject` varchar(256) NOT NULL,
  `emailbody` text NOT NULL,
   PRIMARY KEY  (`download_id`),
   KEY  (item_id, random_value)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_payments` (
  `payment_id` int(11) NOT NULL auto_increment,	
  `txn_id` varchar(256) NOT NULL,
  `item_id` int(11) NULL,
  `user_id` int(11) NULL,
  `user_email` varchar(256) NULL,
  `receiver_email` varchar(256) NULL,
  `paid` int(11) NOT NULL DEFAULT '0',
  `amount` decimal(11,2) NULL,
  `currency` varchar(128) NULL,
  `fee` decimal(11,2) NULL,
  `tax` decimal(11,2) NULL,
  `status` varchar(128) NULL,
  `payment_date` datetime NULL,
  `validate_response` varchar(256) NULL,
  `response` varchar(2048) NULL,
   PRIMARY KEY  (`payment_id`),
   KEY `txn_id` (`txn_id`),
   KEY `payment_date` (`payment_date`)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_users` (
	`userid` INT(11) NOT NULL,
	`paypalaccount` VARCHAR(255)NULL ,
	`last_time_claimed` DATETIME NULL ,
	PRIMARY KEY (`userid`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_users_money` (
	`money_id` INT(11) NOT NULL auto_increment,
	`userid` INT(11) NOT NULL,
	`balance` DECIMAL(11,2) DEFAULT 0,
	`claimed` DECIMAL(11,2) DEFAULT 0,
	`currency` VARCHAR(25) DEFAULT 'USD',
	PRIMARY KEY (`money_id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_shopping_carts` (
	`shoppingcart_id` INT(11) NOT NULL auto_increment,
	`paid` int(11) NOT NULL DEFAULT 0,
	`user_id` INT(11) NULL,
	`time_created` DATETIME NULL ,
	`time_checkedout` DATETIME NULL ,
	`in_process` int(11) NOT NULL DEFAULT 0,
	`total` DECIMAL(11,2) DEFAULT 0,
	`currency` VARCHAR(25) DEFAULT 'USD',
	PRIMARY KEY (`shoppingcart_id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_shopping_cart_item` (
	`shoppingcart_id` INT(11) NOT NULL,
	`item_id` INT(11) NOT NULL,
	`count` INT(11) NOT NULL DEFAULT 0,
	`price` decimal(11,2) NULL,
	`currency` VARCHAR(25) NULL ,
	PRIMARY KEY (`shoppingcart_id`, `item_id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_shopping_cart_item`
	ADD CONSTRAINT `#__digitalmarketx_shopping_cart_item_ibfk_1` FOREIGN KEY (`shoppingcart_id`) 
		REFERENCES `#__digitalmarketx_shopping_carts` (`shoppingcart_id`) ON DELETE CASCADE;	  

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_votes` (
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`state` TINYINT(1)  NOT NULL DEFAULT '1',
`comment_subject` VARCHAR(255)  NULL ,
`comment_text` TEXT NULL ,
`stars` int(11) DEFAULT 0 ,
`thumbs_up` int(11) DEFAULT 0,
`thumbs_down` int(11) DEFAULT 0,
`date_voted` DATETIME NULL ,
`document_id` int(11) UNSIGNED,
`user_id` INT(11) NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_votes`
	ADD CONSTRAINT `#__digitalmarketx_votes_ibfk_1` FOREIGN KEY (`document_id`) 
		REFERENCES `#__digitalmarketx_documents` (`id`) ON DELETE CASCADE;
		
CREATE TABLE IF NOT EXISTS `#__digitalmarketx_votes_replies` (
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`state` TINYINT(1)  NOT NULL DEFAULT '1',
`comment_text` TEXT NULL ,
`vote_id` int(11) UNSIGNED,
`user_id` INT(11) NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_votes_replies`
	ADD CONSTRAINT `#__digitalmarketx_votes_replies_ibfk_1` FOREIGN KEY (`vote_id`) 
		REFERENCES `#__digitalmarketx_votes` (`id`) ON DELETE CASCADE;
		
CREATE TABLE IF NOT EXISTS `#__digitalmarketx_templates` (
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`name` VARCHAR(80)  NOT NULL ,
`details_layout` TEXT NOT NULL ,
`category_layout` TEXT NOT NULL ,
`vote_layout` TEXT NOT NULL ,
`style` TEXT NOT NULL ,
`defaultTemplate` TINYINT(1)  NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) DEFAULT COLLATE=utf8_general_ci;


CREATE TABLE IF NOT EXISTS `#__digitalmarketx_documents_stats`(
`doc_id` int(11) UNSIGNED NOT NULL,
`user_id` int(11),
`download_count` INT(11) NOT NULL DEFAULT 0,
PRIMARY KEY (`doc_id`, user_id)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_documents_stats`
	ADD CONSTRAINT `#__digitalmarketx_documents_stats_ibfk_1` FOREIGN KEY (`doc_id`) 
		REFERENCES `#__digitalmarketx_documents` (`id`) ON DELETE CASCADE;	

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_documents_reports`(
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`doc_id` int(11) UNSIGNED NOT NULL,
`user_id` int(11),
`report_subject` VARCHAR(255)  NULL ,
`report_text` TEXT NULL ,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_documents_reports`
	ADD CONSTRAINT `#__digitalmarketx_documents_reports_ibfk_1` FOREIGN KEY (`doc_id`) 
		REFERENCES `#__digitalmarketx_documents` (`id`) ON DELETE CASCADE;			

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_documents_sales`(
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`doc_id` int(11) UNSIGNED NOT NULL,
`buyer_id` int(11),
`amount` decimal(11,2) NULL,
`currency` VARCHAR(25),
`purchase_time` DATETIME,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_documents_sales`
	ADD CONSTRAINT `#__digitalmarketx_documents_sales_ibfk_1` FOREIGN KEY (`doc_id`) 
		REFERENCES `#__digitalmarketx_documents` (`id`) ON DELETE CASCADE;	