ALTER TABLE #__digitalmarketx_users
	ADD COLUMN `last_time_claimed` DATETIME NULL;
	
CREATE TABLE IF NOT EXISTS `#__digitalmarketx_shopping_carts` (
	`shoppingcart_id` INT(11) NOT NULL auto_increment,
	`paid` int(11) NOT NULL DEFAULT '0',
	`user_id` INT(11) NULL,
	`time_created` DATETIME NULL ,
	`time_checkedout` DATETIME NULL ,
	PRIMARY KEY (`shoppingcart_id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_shopping_cart_item` (
	`shoppingcart_id` INT(11) NOT NULL,
	`item_id` INT(11) NOT NULL,
	`count` INT(11) NOT NULL DEFAULT 0,
	`price` decimal(11,2),
	`currency` VARCHAR(25)  NOT NULL ,
	PRIMARY KEY (`shoppingcart_id`, `item_id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_shopping_cart_item`
	ADD CONSTRAINT `#__digitalmarketx_shopping_cart_item_ibfk_1` FOREIGN KEY (`shoppingcart_id`) 
		REFERENCES `#__digitalmarketx_shopping_carts` (`shoppingcart_id`) ON DELETE CASCADE;	