ALTER TABLE #__digitalmarketx_documents
	ADD COLUMN `download_count` INT(11) NOT NULL DEFAULT 0;
ALTER TABLE #__digitalmarketx_documents
	ADD COLUMN `created_time` DATETIME NULL;
	
CREATE TABLE IF NOT EXISTS `#__digitalmarketx_documents_stats`(
`doc_id` int(11) UNSIGNED NOT NULL,
`user_id` int(11),
`download_count` INT(11) NOT NULL DEFAULT 0,
PRIMARY KEY (`doc_id`, user_id)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_documents_stats`
	ADD CONSTRAINT `#__digitalmarketx_documents_stats_ibfk_1` FOREIGN KEY (`doc_id`) 
		REFERENCES `#__digitalmarketx_documents` (`id`) ON DELETE CASCADE;
		
CREATE TABLE IF NOT EXISTS `#__digitalmarketx_votes_replies` (
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`state` TINYINT(1)  NOT NULL DEFAULT '1',
`comment_text` TEXT NULL ,
`vote_id` int(11) UNSIGNED,
`user_id` INT(11) NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_votes_replies`
	ADD CONSTRAINT `#__digitalmarketx_votes_replies_ibfk_1` FOREIGN KEY (`vote_id`) 
		REFERENCES `#__digitalmarketx_votes` (`id`) ON DELETE CASCADE;

CREATE TABLE IF NOT EXISTS `#__digitalmarketx_documents_reports`(
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`doc_id` int(11) UNSIGNED NOT NULL,
`user_id` int(11),
`report_subject` VARCHAR(255)  NULL ,
`report_text` TEXT NULL ,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_documents_reports`
	ADD CONSTRAINT `#__digitalmarketx_documents_reports_ibfk_1` FOREIGN KEY (`doc_id`) 
		REFERENCES `#__digitalmarketx_documents` (`id`) ON DELETE CASCADE;	
		
CREATE TABLE IF NOT EXISTS `#__digitalmarketx_documents_sales`(
`id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
`doc_id` int(11) UNSIGNED NOT NULL,
`buyer_id` int(11),
`amount` decimal(11,2) NULL,
`currency` VARCHAR(25),
`purchase_time` DATETIME,
PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT COLLATE=utf8_general_ci;

ALTER TABLE `#__digitalmarketx_documents_sales`
	ADD CONSTRAINT `#__digitalmarketx_documents_sales_ibfk_1` FOREIGN KEY (`doc_id`) 
		REFERENCES `#__digitalmarketx_documents` (`id`) ON DELETE CASCADE;	