<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of Digitalmarketx.
 */
class DigitalmarketxViewCurrencies extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
        
		$this->addToolbar();
        
        $input = JFactory::getApplication()->input;
        $view = $input->getCmd('view', '');
        DigitalmarketxHelper::addSubmenu($view);
        
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/digitalmarketx.php';

		$state	= $this->get('State');
		$canDo	= DigitalmarketxHelper::getActions($state->get('filter.category_id'));
		$canChangeCurrenciesRates = $this->canChangeCurrenciesRates();

		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_TITLE_CURRENCIES'), 'currencyexc.png');

		//Check if the form exists before showing the add/edit buttons
        $formPath = JPATH_COMPONENT_ADMINISTRATOR.'/views/currency';
        if (file_exists($formPath)) {

            if ($canDo->get('core.create') && $canChangeCurrenciesRates) {
			    JToolBarHelper::addNew('currency.add','JTOOLBAR_NEW');
		    }

		    if (($canDo->get('core.edit') || $canDo->get('core.edit.own')
				) && $canChangeCurrenciesRates && isset($this->items[0])) {
			    JToolBarHelper::editList('currency.edit','JTOOLBAR_EDIT');
		    }

        }
		
		if ($canDo->get('core.edit.state') && $canChangeCurrenciesRates) {

            if (isset($this->items[0]->state)) {
			    JToolBarHelper::divider();
			    JToolBarHelper::custom('currencies.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
			    JToolBarHelper::custom('currencies.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
            } else if (isset($this->items[0])) {
                //If this component does not use state then show a direct delete button as we can not trash
                JToolBarHelper::deleteList('', 'currencies.delete','JTOOLBAR_DELETE');
            }
		}
        
        //Show trash and delete for components that uses the state field
        if (isset($this->items[0]->state)) {
		    if ($state->get('filter.state') == -2 && $canDo->get('core.delete')
				 && $canChangeCurrenciesRates) {
			    JToolBarHelper::deleteList('', 'currencies.delete','JTOOLBAR_EMPTY_TRASH');
			    JToolBarHelper::divider();
		    } else if ($canDo->get('core.edit.state') && $canChangeCurrenciesRates) {
			    JToolBarHelper::trash('currencies.trash','JTOOLBAR_TRASH');
			    JToolBarHelper::divider();
		    }
        }

		if ($canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_digitalmarketx');
		}
	}
	
	function canChangeCurrenciesRates()
	{
		$user = JFactory::getUser();
		return $user->authorise('digitalmarketx.change_currency_exchange', 'com_digitalmarketx');
	}
	
	public function getSortFields()
	{
		return array(
                'a.id' => JText::_('JGRID_HEADING_ID'),
                'a.source_currency' => JText::_('COM_DIGITALMARKETX_FORM_SOURCE_CURRENCY'),
                'a.dest_currency' => JText::_('COM_DIGITALMARKETX_FORM_DEST_CURRENCY'),
                'a.rate' => JText::_('COM_DIGITALMARKETX_RATE'),
            );
	}
}
