<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */


// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
JHTML::_('script','system/multiselect.js',false,true);
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_digitalmarketx/assets/css/digitalmarketx.css');

$user	= JFactory::getUser();
$userId	= $user->get('id');
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$canOrder	= $user->authorise('core.edit.state', 'com_digitalmarketx');
$saveOrder	= $listOrder == 'a.ordering';
?>
<?php
	VersionLayer::add25AdminStyle();
	require_once JPATH_COMPONENT . "/helpers/digitalmarketx.php";
?>
<form action="<?php echo JRoute::_('index.php?option=com_digitalmarketx&view=documents'); ?>" method="post" name="adminForm" id="adminForm">
	<?php
	$version = new JVersion();
	if($version->RELEASE >= "3.0")
	{
	$sidebar = JHtmlSidebar::render();
	?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
	<?php
	}
	?>
	<?php
	$showStateFilter = true;
	require JPATH_COMPONENT . "/helpers/listheader.php";
	?>
	<table class="adminlist table table-striped">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" value="" onclick="<?php 
					$version = new JVersion(); if($version->RELEASE >= "3.0") echo "Joomla.";?>checkAll(this)" />
				</th>

				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_DOCUMENTS_TITLE', 'a.title', $listDirn, $listOrder); ?>
				</th>
				<th width="30%">
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_FORM_LBL_DOCUMENT_CATEGORY', 'category.title', $listDirn, $listOrder); ?>
				</th>

                <?php if (isset($this->items[0]->state)) { ?>
				<th width="5%">
					<?php echo JHtml::_('grid.sort',  'JPUBLISHED', 'a.state', $listDirn, $listOrder); ?>
				</th>
                <?php } ?>
                <th width="1%" class="nowrap">
                    <?php echo JHtml::_('grid.sort',  'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                </th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="10">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php
		if($this->items)
		{
			foreach ($this->items as $i => $item) :
			$ordering	= ($listOrder == 'a.ordering');
			$canCreate	= $user->authorise('core.create',		'com_digitalmarketx');
			$canEdit = $user->authorise('core.edit', 'com_digitalmarketx.category.'.(int) $item->category);
			if(!$canEdit)
			{
				$canEdit = $item->created_user_id == $userId && $user->authorise('core.edit.own', 'com_digitalmarketx.category.'.(int) $item->category);
			}
			$canCheckin	= $user->authorise('core.manage',		'com_digitalmarketx');
			$canChange = $user->authorise('core.edit.state', 'com_digitalmarketx.category.'.(int) $item->category);
			?>
			<tr class="row<?php echo $i % 2; ?>">
				<td class="center">
					<?php echo JHtml::_('grid.id', $i, $item->id); ?>
				</td>

				<td>
				<?php if (isset($item->checked_out) && $item->checked_out) : ?>
					<?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'documents.', $canCheckin); ?>
				<?php endif; ?>
				<?php if ($canEdit) : ?>
					<a href="<?php echo JRoute::_('index.php?option=com_digitalmarketx&task=document.edit&id='.(int) $item->id); ?>">
					<?php echo $this->escape($item->title); ?></a>
				<?php else : ?>
					<?php echo $this->escape($item->title); ?>
				<?php endif; ?>
				</td>
				<td>
				<?php echo $this->escape($item->categorytitle); ?>
				</td>

                <?php if (isset($this->items[0]->state)) { ?>
				    <td class="center">
					    <?php echo JHtml::_('jgrid.published', $item->state, $i, 'documents.', $canChange, 'cb'); ?>
				    </td>
                <?php } ?>
				<td class="center">
					<?php echo (int) $item->id; ?>
				</td>
			</tr>
			<?php endforeach; 
		}?>
		</tbody>
	</table>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	<?php
	if($version->RELEASE >= "3.0")
	{
	?>
	</div>
	<?php
	}
	?>
</form>