<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of DigitalMarketX.
 */
class DigitalMarketXViewDocuments extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
        
		$this->addToolbar();
        
        $input = JFactory::getApplication()->input;
        $view = $input->getCmd('view', '');
        DigitalMarketXHelper::addSubmenu($view);
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/digitalmarketx.php';

		$state	= $this->get('State');
		$canDo	= DigitalMarketXHelper::getActions($state->get('filter.category_id'));

		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_TITLE_DOCUMENTS'), 'documents.png');

        //Check if the form exists before showing the add/edit buttons
        $formPath = JPATH_COMPONENT_ADMINISTRATOR.'/views/document';
        if (file_exists($formPath)) {

            if ($canDo->get('core.create') && $this->canUpload()) {
			    JToolBarHelper::addNew('document.add','JTOOLBAR_NEW');
		    }

		    if (isset($this->items[0])) {
			    JToolBarHelper::editList('document.edit','JTOOLBAR_EDIT');
		    }

        }

		if ($canDo->get('core.edit.state')) {

            if (isset($this->items[0]->state)) {
			    JToolBarHelper::divider();
			    JToolBarHelper::custom('documents.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
			    JToolBarHelper::custom('documents.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
            } else if (isset($this->items[0])) {
                //If this component does not use state then show a direct delete button as we can not trash
                JToolBarHelper::deleteList('', 'documents.delete','JTOOLBAR_DELETE');
            }

            if (isset($this->items[0]->state)) {
			    JToolBarHelper::divider();
			    JToolBarHelper::archiveList('documents.archive','JTOOLBAR_ARCHIVE');
            }
            if (isset($this->items[0]->checked_out)) {
            	JToolBarHelper::custom('documents.checkin', 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
            }
		}
        
        //Show trash and delete for components that uses the state field
        if (isset($this->items[0]->state)) {
		    if ($state->get('filter.state') == -2 && $canDo->get('core.delete')) {
			    JToolBarHelper::deleteList('', 'documents.delete','JTOOLBAR_EMPTY_TRASH');
			    JToolBarHelper::divider();
		    } else if ($canDo->get('core.edit.state')) {
			    JToolBarHelper::trash('documents.trash','JTOOLBAR_TRASH');
			    JToolBarHelper::divider();
		    }
        }

		if ($canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_digitalmarketx');
		}
		
		$version = new JVersion();
		if($version->RELEASE >= "3.0")
		{
			JHtmlSidebar::setAction('index.php?option=com_digitalmarketx&view=documents');
			JHtmlSidebar::addFilter(
				JText::_('JOPTION_SELECT_PUBLISHED'),
				'filter_state',
				JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true)
			);
		}
	}
	
	public function canUpload()
	{
		$user = JFactory::getUser();
		return 
			$user->authorise('digitalmarketx.upload', 'com_digitalmarketx');
	}
	
	public function getSortFields()
	{
		return array(
		'a.id' => JText::_('JGRID_HEADING_ID'),
		'a.title' => JText::_('COM_DIGITALMARKETX_FORM_LBL_DOCUMENT_TITLE'),
		'a.ordering' => JText::_("JGRID_HEADING_ORDERING"),
		'a.state' => JText::_("COM_DIGITALMARKETX_FORM_LBL_DOCUMENT_STATE"),
		'category.title' => JText::_("COM_DIGITALMARKETX_FORM_LBL_DOCUMENT_CATEGORY")
		);
	}
}
