<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */


// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_digitalmarketx/assets/css/digitalmarketx.css');

$user	= JFactory::getUser();
$userId	= $user->get('id');
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$canOrder	= $user->authorise('core.edit.state', 'com_digitalmarketx');
$saveOrder	= $listOrder == 'downloadlinks.ordering';
?>

<form action="<?php echo JRoute::_('index.php?option=com_digitalmarketx&view=downloadlinks'); ?>" method="post" name="adminForm" id="adminForm">
	<?php
	$version = new JVersion();
	if($version->RELEASE >= "3.0")
	{
	$sidebar = JHtmlSidebar::render();
	?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
	<?php
	}
	?>
	<?php
	$showStateFilter = false;
	require JPATH_COMPONENT . "/helpers/listheader.php";
	?>
	<table class="adminlist table table-striped">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" value="" onclick="<?php 
					$version = new JVersion(); if($version->RELEASE >= "3.0") echo "Joomla.";?>checkAll(this)" />
				</th>

				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_DOWNLOADLINK_EMAIL', 'payer_email', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_DOWNLOADLINK_DOCUMENT', 'doc_name', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_DOWNLOADLINK_DOWNLOAD_COUNT', 'download_hits', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_DOWNLOADLINK_MAXDOWNLOADS', 'link_max_downloads', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_DOWNLOADLINK_EXPIRATION_DATE', 'expiration_date', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_DOWNLOADLINK_PAID', 'paid', $listDirn, $listOrder); ?>
				</th>
                <th width="1%" class="nowrap">
                    <?php echo JHtml::_('grid.sort',  'JGRID_HEADING_ID', 'download_id', $listDirn, $listOrder); ?>
                </th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="11">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php
		if($this->items)
		{
		foreach ($this->items as $i => $item) :
			?>
			<tr class="row<?php echo $i % 2; ?>">
				<td class="center">
					<?php echo JHtml::_('grid.id', $i, $item->download_id); ?>
				</td>
				<td>
				<a href="<?php echo JRoute::_('index.php?option=com_digitalmarketx&task=downloadlink.edit&download_id='.(int) $item->download_id); ?>">
				<?php echo $this->escape($item->payer_email); ?></a>
				</td>
				<td>
				<?php echo $this->escape($item->doc_name); ?>
				</td>
				<td>
				<?php echo $this->escape($item->download_hits); ?></a>
				</td>
				<td>
				<?php echo $this->escape($item->link_max_downloads); ?>
				</td>
				<td>
				<?php echo $this->escape($item->expiration_date); ?>
				</td>
				<td>
				<?php echo JHtml::_('jgrid.published', $item->paid, $i, 'downloadlinks.', false, 'cb'); ?>
				</td>
				<td>
				<?php echo $this->escape($item->download_id); ?>
				</td>
			</tr>
			<?php endforeach; 
		}?>
		</tbody>
	</table>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	<?php
	if($version->RELEASE >= "3.0")
	{
	?>
	</div>
	<?php
	}
	?>
</form>