<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of DigitalMarketX.
 */
class DigitalMarketXViewDownloadLinks extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
        
		$this->addToolbar();
        
        $input = JFactory::getApplication()->input;
        $view = $input->getCmd('view', '');
        DigitalMarketXHelper::addSubmenu($view);
        
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/digitalmarketx.php';

		$state	= $this->get('State');
		$canDo	= DigitalMarketXHelper::getActions($state->get('filter.category_id'));

		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_DOWNLOAD_LINKS'), 'downloadlinks.png');

        //Check if the form exists before showing the add/edit buttons
        $formPath = JPATH_COMPONENT_ADMINISTRATOR.'/views/downloadlink';
        if (file_exists($formPath)) {

            if ($canDo->get('core.create')) {
			    JToolBarHelper::addNew('downloadlink.addnew','JTOOLBAR_NEW');
		    }

		    if (($canDo->get('core.edit') || $canDo->get('core.edit.own')
				) && isset($this->items[0])) {
			    JToolBarHelper::editList('downloadlink.edit','JTOOLBAR_EDIT');
		    }

        }

		if ($canDo->get('core.edit.state')) {

            if (isset($this->items[0]->state)) {
			    JToolBarHelper::divider();
			    JToolBarHelper::custom('downloadlinks.publish', 'publish.png', 'publish_f2.png','JTOOLBAR_PUBLISH', true);
			    JToolBarHelper::custom('downloadlinks.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
            } else if (isset($this->items[0])) {
                //If this component does not use state then show a direct delete button as we can not trash
                JToolBarHelper::deleteList('', 'downloadlinks.delete','JTOOLBAR_DELETE');
            }

            if (isset($this->items[0]->state)) {
			    JToolBarHelper::divider();
			    JToolBarHelper::archiveList('downloadlinks.archive','JTOOLBAR_ARCHIVE');
            }
            if (isset($this->items[0]->checked_out)) {
            	JToolBarHelper::custom('documents.checkin', 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
            }
		}
        
        //Show trash and delete for components that uses the state field
        if (isset($this->items[0]->state)) {
		    if ($state->get('filter.state') == -2 && $canDo->get('core.delete')) {
			    JToolBarHelper::deleteList('', 'downloadlinks.delete','JTOOLBAR_EMPTY_TRASH');
			    JToolBarHelper::divider();
		    } else if ($canDo->get('core.edit.state')) {
			    JToolBarHelper::trash('downloadlinks.trash','JTOOLBAR_TRASH');
			    JToolBarHelper::divider();
		    }
        }

		if ($canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_digitalmarketx');
		}
	}
	
	public function getSortFields()
	{
		return array(
                'download_id' => JText::_('COM_DIGITALMARKETX_DOWNLOADLINK_ID'),
				'payer_email' => JText::_('COM_DIGITALMARKETX_DOWNLOADLINK_EMAIL'),
                'doc_name' => JText::_('COM_DIGITALMARKETX_DOWNLOADLINK_DOCUMENT'),
                'download_hits' => JText::_('COM_DIGITALMARKETX_DOWNLOADLINK_DOWNLOAD_COUNT'),
                'link_max_downloads' => JText::_('COM_DIGITALMARKETX_DOWNLOADLINK_MAXDOWNLOADS'),
                'expiration_date' => JText::_('COM_DIGITALMARKETX_DOWNLOADLINK_EXPIRATION_DATE'),
                'paid' => JText::_('COM_DIGITALMARKETX_DOWNLOADLINK_PAID')
            );
	}
}
