<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */


// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_digitalmarketx/assets/css/digitalmarketx.css');

$root = JURI::root();
?>
<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		Joomla.submitform(task, document.getElementById('document-form'));
	}
</script>
<form method="post" name="adminForm" id="document-form" class="form-validate" >
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="user_id" value="<?php echo (int)$this->user_id;?>" />
	<?php echo JHtml::_('form.token'); ?>

<?php 
if($this->profile)
{
?>
<fieldset class="adminform">
<legend><?php echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKETX_EDIT_USER_BALANCE_FOR_USER", $this->profile->name));?></legend>
<table>
<thead>
<th><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_USER_BALANCE"));?></th>
<th><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_USER_CLAIMED"));?></th>
<th><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_FORM_CURRENCY"));?></th>
</thead>	
<tbody>
<?php
	$i = 0;
	foreach($this->money as $currency)
	{
?>
<tr>
	<td>
	<input type="hidden" name="money_id_<?php echo $i;?>" value="<?php echo (int)$currency->money_id;?>"/>
	<input type="text" name="balance_<?php echo $i;?>" value="<?php echo (float)$currency->balance;?>" />
	</td>
	<td>
	<input type="text" name="claimed_<?php echo $i;?>" value="<?php echo (float)$currency->claimed;?>" />
	</td>
	<td>
	<?php echo htmlspecialchars($currency->currency);?>
	</td>
</tr>
<?php
		$i++;
	}
?>
</tbody>
</table>
<input type="hidden" name="money_count" value="<?php echo (int)count($this->money);?>"/>
</fieldset>
<?php
}
else
	echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_NOPAYPALACCOUNT"));
?>

</form>