<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View to edit
 */
class DigitalmarketxViewImportTemplate extends JViewLegacy
{

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);

		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_TITLE_TEMPLATE'), 'thememanager.png');

		// If not checked out, can save the item.
		$user = JFactory::getUser();
		if ($user->authorise('core.create', 'com_digitalmarketx'))
		{
			JToolBarHelper::save('template.import', 'COM_DIGITALMARKETX_IMPORT_TEMPLATE_BUTTON');
		}
		JToolBarHelper::cancel('template.cancel', 'JTOOLBAR_CANCEL');
	}
}
