<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of DigitalMarketX.
 */
class DigitalMarketXViewJUsers extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		
		$option = JRequest::getVar('option');
		VersionLayer::script('usersmodal.js', 'administrator/components/'. $option . '/js/');

		$model = $this->getModel();
		
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
        
        $input = JFactory::getApplication()->input;
        $view = $input->getCmd('view', '');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
	}
	
	public function getSortFields()
	{
		return array(
                'userid' => JText::_('JGRID_HEADING_ID'),
				'name' => JText::_('COM_DIGITALMARKETX_USERNAME'),
                'paypalaccount' => JText::_('COM_DIGITALMARKETX_PAYPAL_ACCOUNT')
            );
	}
}
