<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of DigitalMarketX.
 */
class DigitalMarketXViewPayments extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
        
		$this->addToolbar();
        
        $input = JFactory::getApplication()->input;
        $view = $input->getCmd('view', '');
        DigitalMarketXHelper::addSubmenu($view);
        
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/digitalmarketx.php';

		$state	= $this->get('State');

		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_PAYMENTS'), 'payments.png');

        //Check if the form exists before showing the add/edit buttons
        $formPath = JPATH_COMPONENT_ADMINISTRATOR.'/views/payment';
        if (file_exists($formPath)) {

		    if (isset($this->items[0])) {
			    JToolBarHelper::editList('document.edit','JTOOLBAR_EDIT');
		    }

        }
        
		JToolBarHelper::deleteList('', 'payments.delete','JTOOLBAR_DELETE');
		JToolBarHelper::divider();
		$user = JFactory::getUser();
		if ($user->authorise('core.manage', 'com_digitalmarketx')) {
			JToolBarHelper::preferences('com_digitalmarketx');
		}
	}
	
	public function getSortFields()
	{
		return array(
                'payment_id' => JText::_('COM_DIGITALMARKETX_FORM_PAYMENTID'),
				'txn_id' => JText::_('COM_DIGITALMARKETX_FORM_TRANSACTION'),
                'user_name' => JText::_('COM_DIGITALMARKETX_FORM_USER'),
                'user_email' => JText::_('COM_DIGITALMARKETX_FORM_USER_EMAIL'),
                'receiver_email' => JText::_('COM_DIGITALMARKETX_FORM_RECEIVER_EMAIL'),
                'amount' => JText::_('COM_DIGITALMARKETX_FORM_AMOUNT'),
                'fee' => JText::_('COM_DIGITALMARKETX_FORM_FEE'),
				'currency' => JText::_('COM_DIGITALMARKETX_FORM_CURRENCY'),
                'status' => JText::_('COM_DIGITALMARKETX_FORM_STATUS'),
                'payment_date' => JText::_('COM_DIGITALMARKETX_FORM_PAYMENTDATE'),
                'paid' => JText::_('COM_DIGITALMARKETX_FORM_PAID')
            );
	}
}
