<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */


// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_digitalmarketx/assets/css/digitalmarketx.css');

$paypal_button_lang_folder = JText::_("COM_DIGITALMARKETX_PAYPAL_BUTTON_LANGUAGE_FOLDER");
$root = JURI::root();
?>
<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		Joomla.submitform(task, document.getElementById('document-form'));
	}
</script>
<form method="post" name="adminForm" id="document-form" class="form-validate" >
	<input type="hidden" name="task" value="" />
	<?php echo JHtml::_('form.token'); ?>
</form>
<?php 
if($this->paymentConfig)
{
	if($this->paymentConfig->testmode)
	{
		if($this->paymentConfig->use_simulator)
			$paypal = $root . "index.php?option=com_digitalmarketx&amp;task=paypal.simulatepay";
		else
			$paypal = "https://www.sandbox.paypal.com/cgi-bin/webscr";
	}
	else
		$paypal = "https://www.paypal.com/cgi-bin/webscr";
}
if($this->profile && $this->profile->paypalaccount)
{
?>
<fieldset class="adminform">
<legend><?php echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKETX_PAYMENT_TO_USER", $this->profile->name));?></legend>
<ul class="adminformlist">
	
<?php
	foreach($this->money as $currency)
	{
?>
<li>
<label><?php echo htmlspecialchars($currency->claimed . " " . $currency->currency);?></label>
<form method="post" name="paymentform" action="<?php echo $paypal;?>">
<input type="hidden" name="cmd" value="_xclick"/>
<input type="hidden" name="business" value="<?php echo htmlspecialchars($this->profile->paypalaccount);?>"/>
<input type="hidden" name="custom" value="<?php echo htmlspecialchars($currency->money_id);?>"/>
<input type="hidden" name="item_number" value="<?php echo htmlspecialchars($currency->userid);?>"/>
<input type="hidden" name="item_name" value="<?php echo htmlspecialchars(JText::sprintf("COM_DIGITALMARKETX_PAYMENT_TO_USER", $this->profile->name));?>"/>
<input type="hidden" name="amount" value="<?php echo htmlspecialchars($currency->claimed);?>"/>
<input type="hidden" name="currency_code" value="<?php echo htmlspecialchars($currency->currency);?>"/>
<input type="hidden" name="notify_url" value="<?php echo $root;?>index.php?option=com_digitalmarketx&amp;task=paypal.confirmdebtpay"/>
<?php
	$return = $root . "administrator/index.php?option=com_digitalmarketx&amp;view=users";
?>
<input type="hidden" name="return" value="<?php echo $return;?>"/>
<input type="hidden" name="no_note" value="1"/>
<input type="hidden" name="no_shipping" value="1"/>
<input type="hidden" name="rm" value="2"/>
<input type="image" src="http://www.paypal.com/<?php echo $paypal_button_lang_folder;?>/i/btn/btn_paynowCC_LG.gif" name="submit" alt="<?php echo JText::_("COM_DIGITALMARKETX_PAYPAL_BUTTON_ALTERNATE_TEXT");?>"/>
<img alt="" src="https://www.paypal.com/<?php echo $paypal_button_lang_folder;?>/i/scr/pixel.gif" width="1" height="1"/>
</form>
</li>
<?php
	}
?>

</ul>
</fieldset>
<?php
}
else
	echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_NOPAYPALACCOUNT"));
?>