<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of DigitalMarketX.
 */
class DigitalMarketXViewPayUser extends JViewLegacy
{

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$model = $this->getModel();
		$id = JRequest::getInt('id');
		if($id > 0)
		{
			if(JFactory::getUser()->authorise('digitalmarketx.payuser', 'com_digitalmarketx'))
			{
				$this->profile = $model->getProfileForUser($id);
				$this->money = $model->getMoneyForUser($id);
				$this->paymentConfig = $model->getPaymentConfig();
				// Check for errors.
				if (count($errors = $this->get('Errors'))) {
					throw new Exception(implode("\n", $errors));
				}
				$this->addToolbar();
				$input = JFactory::getApplication()->input;
				$view = $input->getCmd('view', '');
				
				DigitalMarketXHelper::addSubmenu($view);
				parent::display($tpl);
			}
			else
				echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_UNAUTHORIZED"));
		}
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_PAYUSER'), 'document.png');
		JToolBarHelper::cancel('users.cancel', 'JTOOLBAR_CLOSE');
	}
}
