<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View to edit
 */
class DigitalmarketxViewReport extends JViewLegacy
{
	protected $state;
	protected $item;
	protected $form;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state	= $this->get('State');
		$this->item		= $this->get('Item');
		$this->form		= $this->get('Form');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		$isNew		= ($this->item->id == 0);
        if (isset($this->item->checked_out)) {
		    $checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $user->get('id'));
        } else {
            $checkedOut = false;
        }
		$canDo		= DigitalmarketxHelper::getActions();

		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_REPORT'), 'reports.png');

		if($user->authorise('digitalmarketx.update_user_balance'))
			JToolBarHelper::custom('report.proceed', 'checkin.png', 'checkin.png', 'COM_DIGITALMARKETX_REPORT_PROCEED', false);
		
		if (empty($this->item->id)) {
			JToolBarHelper::cancel('report.cancel', 'JTOOLBAR_CANCEL');
		}
		else {
			JToolBarHelper::cancel('report.cancel', 'JTOOLBAR_CLOSE');
		}

	}
}
