<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */


// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_digitalmarketx/assets/css/digitalmarketx.css');

$user	= JFactory::getUser();
$userId	= $user->get('id');
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$canOrder	= $user->authorise('core.edit.state', 'com_digitalmarketx');
$saveOrder	= $listOrder == 'a.ordering';
?>

<form action="<?php echo JRoute::_('index.php?option=com_digitalmarketx&view=reports'); ?>" method="post" name="adminForm" id="adminForm">
	<?php
	$version = new JVersion();
	if($version->RELEASE >= "3.0")
	{
	$sidebar = JHtmlSidebar::render();
	?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
	<?php
	}
	?>
	<?php
	$showStateFilter = false;
	require JPATH_COMPONENT . "/helpers/listheader.php";
	?>
	<table class="adminlist table table-striped">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" value="" onclick="<?php 
					$version = new JVersion(); if($version->RELEASE >= "3.0") echo "Joomla.";?>checkAll(this)" />
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_REPORT_SUBJECT', 'a.report_subject', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_REPORT_BODY', 'a.report_text', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_DOCUMENT_TITLE', 'doc_title', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_USER_WHO_REPORTED', 'user_id.name', $listDirn, $listOrder); ?>
				</th>
                <?php if (isset($this->items[0]->id)) { ?>
                <th width="1%" class="nowrap">
                    <?php echo JHtml::_('grid.sort',  'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                </th>
                <?php } ?>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="10">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php 
		if($this->items)
		{
			foreach ($this->items as $i => $item) :
			$ordering	= ($listOrder == 'a.ordering');
			$canCreate	= $user->authorise('core.create',		'com_digitalmarketx');
			$canEdit	= $user->authorise('core.edit',			'com_digitalmarketx');
			$canCheckin	= $user->authorise('core.manage',		'com_digitalmarketx');
			$canChange	= $user->authorise('core.edit.state',	'com_digitalmarketx');
			?>
			<tr class="row<?php echo $i % 2; ?>">
				<td class="center">
					<?php echo JHtml::_('grid.id', $i, $item->id); ?>
				</td>
				<td>
				<?php if ($canEdit) : ?>
					<a href="<?php echo JRoute::_('index.php?option=com_digitalmarketx&task=report.edit&id='.(int) $item->id); ?>">
					<?php echo $this->escape($item->report_subject); ?></a>
				<?php else : ?>
					<?php echo $this->escape($item->report_subject); ?>
				<?php endif; ?>
				</td>
				<td>
					<?php 
					$text = $this->escape($item->report_text);
					if(mb_strlen($text) > 200)
						$text = mb_substr($text, 0, 200) . "...";
					echo $text; 
					?>
				</td>
				<td>
					<?php echo $this->escape($item->doc_title); ?>
				</td>
                <td>
					<?php echo $item->user_id; ?>
				</td>
                <?php if (isset($this->items[0]->id)) { ?>
				<td class="center">
					<?php echo (int) $item->id; ?>
				</td>
                <?php } ?>
			</tr>
			<?php endforeach; 
		}?>
		</tbody>
	</table>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	<?php
	if($version->RELEASE >= "3.0")
	{
	?>
	</div>
	<?php
	}
	?>
</form>