<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of Digitalmarketx.
 */
class DigitalmarketxViewReports extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
        
		$this->addToolbar();
        
        $input = JFactory::getApplication()->input;
        $view = $input->getCmd('view', '');
        DigitalmarketxHelper::addSubmenu($view);
        
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/digitalmarketx.php';
		require_once JPATH_COMPONENT.'/config.php';

		$state	= $this->get('State');
		$canDo	= DigitalmarketxHelper::getActions($state->get('filter.category_id'));

		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_REPORTS'), 'reports.png');

		//Check if the form exists before showing the add/edit buttons
        $formPath = JPATH_COMPONENT_ADMINISTRATOR.'/views/report';
        if (file_exists($formPath)) {
			$user = JFactory::getUser();
		    if(EDIT_USER_BALANCE && $user->authorise('digitalmarketx.update_user_balance'))
			{
				JToolBarHelper::custom('report.edit', 'checkin.png', 'checkin.png', 'COM_DIGITALMARKETX_REPORT_PROCEED', true);
		    }

        }
		
		if ($canDo->get('core.edit.state')) {

            JToolBarHelper::deleteList('', 'reports.delete','JTOOLBAR_DELETE');
		}
		if ($canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_digitalmarketx');
		}


	}
	
	public function getSortFields()
	{
		return array(
                'id' => JText::_('JGRID_HEADING_ID'),
				'name' => JText::_('COM_DIGITALMARKETX_USERNAME'),
                'report_subject' => JText::_('COM_DIGITALMARKETX_REPORT_SUBJECT')
            );
	}
}
