<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */


// no direct access
defined('_JEXEC') or die;

JHtml::_('behavior.tooltip');
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_digitalmarketx/assets/css/digitalmarketx.css');

$user	= JFactory::getUser();
$userId	= $user->get('id');
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$saveOrder	= $listOrder == 'users.ordering';

require_once JPATH_COMPONENT . "/config.php";

?>

<form action="<?php echo JRoute::_('index.php?option=com_digitalmarketx&view=users'); ?>" method="post" name="adminForm" id="adminForm">
	<?php
	$version = new JVersion();
	if($version->RELEASE >= "3.0")
	{
	$sidebar = JHtmlSidebar::render();
	?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
	<?php
	}
	?>
	<?php
	$showStateFilter = false;
	require JPATH_COMPONENT . "/helpers/listheader.php";
	?>
	<table class="adminlist table table-striped">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" value="" onclick="<?php 
					$version = new JVersion(); if($version->RELEASE >= "3.0") echo "Joomla.";?>checkAll(this)" />
				</th>

				<th class='left' width="20%">
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_USERNAME', 'name', $listDirn, $listOrder); ?>
				</th>
				<th class='left' width="20%">
				<?php echo JHtml::_('grid.sort',  'COM_DIGITALMARKETX_PAYPAL_ACCOUNT', 'paypalaccount', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo htmlspecialchars(JText::_('COM_DIGITALMARKETX_MONEY')); ?>
				</th>
                <th width="1%" class="nowrap">
                    <?php echo JHtml::_('grid.sort',  'JGRID_HEADING_ID', 'userid', $listDirn, $listOrder); ?>
                </th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="11">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php 
		if($this->items)
		{
			foreach ($this->items as $i => $item) :
			?>
			<tr class="row<?php echo $i % 2; ?>">
				<td class="center">
					<?php echo JHtml::_('grid.id', $i, $item->userid); ?>
				</td>
				<td>
				<?php echo $this->escape($item->name); ?>
				</td>
				<td>
				<?php echo $this->escape($item->paypalaccount); ?>
				</td>
				<td>
				<?php
					$count = 0;
					foreach($item->money as $currency){ 
					if($currency->claimed > 0)
					{
						$count++;
						echo htmlspecialchars($currency->claimed . " " . $currency->currency) . "&nbsp;&nbsp;&nbsp;";
					}
				}
				if($count > 0 && $user->authorise('digitalmarketx.payuser', 'com_digitalmarketx'))
				{
				?>
				<a href="index.php?option=com_digitalmarketx&view=payuser&id=<?php echo (int)$item->userid;?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_PAY"));?></a>
				<?php
				}
				if(EDIT_USER_BALANCE && JFactory::getUser()->authorise('digitalmarketx.update_user_balance', 'com_digitalmarketx'))
				{
				?>
				&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?option=com_digitalmarketx&view=edituserbalance&id=<?php echo (int)$item->userid;?>"><?php echo htmlspecialchars(JText::_("COM_DIGITALMARKETX_EDIT_USER_BALANCE"));?></a>
				<?php
				}
				?>
				
				</td>
				<td>
				<?php echo $this->escape($item->userid); ?>
				</td>
			</tr>
			<?php 
			endforeach; 
		}?>
		</tbody>
	</table>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	<?php
	if($version->RELEASE >= "3.0")
	{
	?>
	</div>
	<?php
	}
	?>
</form>