<?php
/**
 * @version     1.0.0
 * @package     com_digitalmarketx
 * @copyright   Copyright (C) 2012. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ratmil <ratmil_torres@yahoo.com> - http://www.ratmilwebsolutions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of DigitalMarketX.
 */
class DigitalMarketXViewUsers extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->state		= $this->get('State');
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');

		$model = $this->getModel();
		$model->setMoneyForItems( $this->items );
		
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
        
		$this->addToolbar();
        
        $input = JFactory::getApplication()->input;
        $view = $input->getCmd('view', '');
        DigitalMarketXHelper::addSubmenu($view);
        
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT.'/helpers/digitalmarketx.php';

		$user = JFactory::getUser();
		$user->authorise('digitalmarketx.upload', 'com_digitalmarketx');
		JToolBarHelper::title(JText::_('COM_DIGITALMARKETX_USERS'), 'users.png');
		if ($user->authorise('core.admin', 'com_digitalmarketx')) {
			JToolBarHelper::preferences('com_digitalmarketx');
		}
	}
	
	public function getSortFields()
	{
		return array(
                'userid' => JText::_('JGRID_HEADING_ID'),
				'name' => JText::_('COM_DIGITALMARKETX_USERNAME'),
                'paypalaccount' => JText::_('COM_DIGITALMARKETX_PAYPAL_ACCOUNT')
            );
	}
}
