<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

/**
 * Import controller class.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 * @since       1.6
 */
class JoresponderControllerImport extends JControllerLegacy
{
	public function __construct($config = array())
	{
		parent::__construct();
		
		// Register Extra task
		$this->registerTask( 'apply', 	'saveImported' );
	}
	
	/**
	 * Saves the imported file
	 */
	public function saveImported()
	{
		
		// Check for request forgeries
		JRequest::checkToken('request') or jexit(JText::_('JINVALID_TOKEN'));

		// Get the user
		$db = JFactory::getDBO();
		$user		= JFactory::getUser();
		$user_params	= JComponentHelper::getParams('com_users');
		jimport( 'joomla.filesystem.file' );

		// Get some data from the request
		$file		= JRequest::getVar('fileToImport', '', 'files', 'array');

		// Make the filename safe
		$file['name']	= JFile::makeSafe($file['name']);
		
		// First upload the file to upload directory
		if (isset($file['name'])) {

			$path = COM_JORESPONDER_FILEPATH.'/';

			//sanitize filename further and make unique
			$filepath = JPath::clean(COM_JORESPONDER_FILEPATH.'/'.strtolower($file['name']));			
		
			if (!JFile::upload($file['tmp_name'], $filepath)) {
				$this->setRedirect('index.php?option=com_joresponder&view=users', JText::_('Unable to upload file'), 'error');
				return false;
			}
		}
		
		/** Include PHPExcel_IOFactory */
		require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/PHPExcel/Classes/PHPExcel/IOFactory.php');
		$inputFileType = 'CSV';
		$inputFileName = $filepath;
		$objReader = PHPExcel_IOFactory::createReader($inputFileType);
		$objPHPExcel = $objReader->load($inputFileName);
		
		$objWorksheet = $objPHPExcel->getActiveSheet();
		$highestRow = $objWorksheet->getHighestRow();
		$highestColumn = $objWorksheet->getHighestColumn();
		$highestColumnIndex = PHPExcel_Cell::columnIndexFromString($highestColumn);
	     
		//read from file
		$rows = array();
		$startrow = empty($_POST['skip_title_row']) ? 0 : 1;
		for ($row = $startrow; $row <= $highestRow; ++$row)
		{
			$file_data = array();
			for ($col = 0; $col < $highestColumnIndex; ++$col)
			{ 
				$value=$objWorksheet->getCellByColumnAndRow($col, $row)->getValue();
				$file_data[$col]=trim($value);
			}
			$rows[] = $file_data;
		}
		
		if(!empty($rows)) {
			$cparams = JComponentHelper::getParams('com_joresponder');
			
			$email_sender = $cparams->get('email_sender', '');
			$redirect_url = $cparams->get('redirect_url', 'index.php');
			$optin = $cparams->get('optin', 0);
			$subscribe_notify = $cparams->get('subscribe_notify', 1);
			$unsubscribe_notify = $cparams->get('unsubscribe_notify', 1);
			
			foreach($rows as $key => $row) {
				
				if($key>0) 	{
					$item_model     = $this->getModel('Users');
					$item_table 	= $item_model->getTable();
					
					$item_data = array('name' => $row[0],
							   'alias' => JFilterOutput::stringURLSafe($row[0]),
							   'email' => $row[1],
							   'state' => 1
							);
					$item_table->bind($item_data);
					$all_ok = true;
					if(!$item_table->check()) {
						$all_ok = false;
					}
					
					if($all_ok and $item_table->store()) {						
						$code = substr(md5($item_table->email.microtime()),0,8);
						$uid = $item_table->id;
						
						// update this user with the new confirmation code
						$user_data = new stdClass();
						$user_data->id = $uid;
						$user_data->state = ($optin) ? 0 : 1;
						$user_data->code = $code;
						$user_data->ip = $_SERVER['REMOTE_ADDR'];
						
						try { 
							$result = $db->updateObject('#__joresponder_users', $user_data, 'id');
						} catch (Exception $e) {
							// catch the error.
							
						}
						
						if($optin) {
							
							// send confirmation email
							$url=JURI::root()."index.php?option=com_joresponder&task=confirm&code=$code&id=$uid";
							
							$subject="Please confirm your email";
							$message="Please click on the link below or copy and paste it in the browser address bar:<br><br>".
							'<a href="'.$url.'">'.$url.'</a>';		
							
							$this->_send_mail($email_sender, $item_table->email, $subject, $message);
						}
						else {
							
							$this->_send_welcome_mail($uid);
			
							// notify admin?
							if($subscribe_notify==1) {
								$this->_subscribe_notify($uid);
							}
						}
					} // end if($item_table->store())
				} // end if key > 0
			} // end foreach $row
		} // end if not empty $rows
		
		// delete this uploaded file
		unlink($filepath);
		$msg = JText::_('COM_JORESPONDER_IMPORT_DONE');
		$this->setRedirect('index.php?option=com_joresponder&view=users', $msg);
	}
	
	/* sends the first welcome mail to newly registered or imported user
	if such has been scheduled. Scheduling of those mails is done by setting "0" for "days" */
	/* sends the first welcome mail to newly registered or imported user
	if such has been scheduled. Scheduling of those mails is done by setting "0" for "days" */
	private function _get_welcome_mail()
	{
		$db  	=  JFactory::getDBO();
		
		// first check if this email is already registered
		$query = 'SELECT *'
			. ' FROM #__joresponder_messages'
			. ' WHERE send_after_days = 0';
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$welcome_mail = $db->loadObject();
		return $welcome_mail;
	}
	
	private function _send_welcome_mail($uid)
	{
		$db  	=  JFactory::getDBO();
		
		// select member
		$query = 'SELECT *'
			. ' FROM #__joresponder_users'
			. ' WHERE id = '.(int)$uid
			. ' AND state = 1'
			;
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$member = $db->loadObject();
		
		if(empty($member)) return false;
		
		$mail = $this->_get_welcome_mail();
		if(empty($mail)) return false;
		
		$this->_customize_welcome_email($mail,$member);
	}
	
	/* private function called to customize an email message and send it */
	private function _customize_welcome_email($mail,$member)
	{
		$cparams = JComponentHelper::getParams('com_joresponder');
		$email_sender = $cparams->get('email_sender', '');
		
		// send mail to member
		$subject=$mail->name;				
		$message=$mail->text;
		
		$subject=str_replace("{{name}}",$member->name,$subject);
		$subject=str_replace("{{email}}",$member->email,$subject);
		
		$message=str_replace("{{name}}",$member->name,$message);
		$message=str_replace("{{email}}",$member->email,$message);

		// add unsubscribe link
		$unsub_url = JURI::root()."index.php?option=com_joresponder&task=unsubscribe&email=".urlencode($member->email);
		$message.="<br><br>
		To unsubscribe from our list visit the url below:<br>
		<a href='$unsub_url'>$unsub_url</a>";
		$message=str_replace("\t","",$message);
		
		$this->_send_mail($email_sender,$member->email,$subject,$message);
		
		// record this date time
		$db  	=  JFactory::getDBO();
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->format('Y-m-d H:i:s', true);
		
		$data = new stdClass();
		$data->user_id = $member->id;
		$data->email_id = $mail->id;
		$data->track_date = $now;
		 
		try {
			$result = $db->insertObject('#__joresponder_tracks', $data);
		} catch (Exception $e) {
		}
	}
	// send notice when someone subscribes
	private function _subscribe_notify($mid)
	{
		$db  	=  JFactory::getDBO();
		$cparams = JComponentHelper::getParams('com_joresponder');
		$email_sender = $cparams->get('email_sender', '');
		
		$query = 'SELECT *'
			. ' FROM #__joresponder_users'
			. ' WHERE id = '.(int)$mid
			;
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$member = $db->loadObject();
		
		$subject = "New user subscribed to the mailing list";
		$message = 'User details:'."<br><p>".'Name:'.' '.$member->name.
			'</p><p>'.'Email:'.' '.$member->email;
		
		$this->_send_mail("",$email_sender,$subject,$message);
	}
	/* wrapper for joomla mail function */
	private function _send_mail($from="",$to,$subject,$message)
	{
		$db  	=  JFactory::getDBO();
		$mail = JFactory::getMailer();
		$jconfig = new JConfig();
		$MailFrom = $jconfig->mailfrom;
		$FromName = $jconfig->fromname;
		
		if($from!="") {
			$mail->setSender($from);
		}
		else {
			$mail->setSender(array($MailFrom, $FromName));
		}
		
		$mail->setSubject($subject);
		$mail->setBody($message);
		$mail->IsHTML(true);
		$mail->addRecipient($to);
	
		$sent = $mail->Send();
	}
}
