<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die;

/**
 * Joresponder component helper.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 * @since       1.6
 */
class JoresponderHelper
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string	The name of the active view.
	 *
	 * @return  void
	 * @since   1.6
	 */
	public static function addSubmenu($vName)
	{
		JHtmlSidebar::addEntry(
			JText::_('COM_JORESPONDER_SUBMENU_MESSAGES'),
			'index.php?option=com_joresponder&view=messages',
			$vName == 'messages'
		);
		
		JHtmlSidebar::addEntry(
			JText::_('COM_JORESPONDER_SUBMENU_USERS'),
			'index.php?option=com_joresponder&view=users',
			$vName == 'users'
		);
		
		JHtmlSidebar::addEntry(
			JText::_('COM_JORESPONDER_SUBMENU_TRACKS'),
			'index.php?option=com_joresponder&view=tracks',
			$vName == 'tracks'
		);
		
		JHtmlSidebar::addEntry(
			JText::_('COM_JORESPONDER_SUBMENU_FORM'),
			'index.php?option=com_joresponder&view=form',
			$vName == 'form'
		);
	}
	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @param   integer  The category ID.
	 *
	 * @return  JObject
	 * @since   1.6
	 */
	public static function getActions()
	{
		$user	= JFactory::getUser();
		$result	= new JObject;

		$assetName = 'com_joresponder';
		$level = 'component';

		$actions = JAccess::getActions('com_joresponder', $level);

		foreach ($actions as $action)
		{
			$result->set($action->name,	$user->authorise($action->name, $assetName));
		}

		return $result;
	}
	
	/**
	 * Synchronize Joomla users with Joresponder user list
	 */
	public function syncJoomlaUsers()
	{
		//initialise variables
		$db  	= JFactory::getDBO();
		$date = JFactory::getDate();
		$user = JFactory::getUser();
		$myId = $user->get('id');
		
		$query = 'SELECT *'
			. ' FROM #__users'
			. ' WHERE activation = ""'
			. ' AND block = 0';
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$users = $db->loadObjectList();
		
		if(!empty($users))
		{
			foreach($users as $user)
			{
				$query = 'SELECT *'
					. ' FROM #__joresponder_users'
					. ' WHERE email = '.$db->Quote($user->email)
					. ' AND state = 1';
				
				$db->setQuery($query);
				if(!$db->query()){
					JError::raiseError(500, $db->getErrorMsg());
					return false;
				}
				$au_user = $db->loadObject();
				
				if(empty($au_user))
				{
					// record this date time 
					$item_data = new stdClass();
					$item_data->name = $user->name;
					$item_data->alias = JFilterOutput::stringURLSafe($user->name);
					$item_data->email = $user->email;
					$item_data->state = 1;
					$item_data->created_time = $date->toSql();
					$item_data->created_by = $myId;
					 
					try {
						$result = $db->insertObject('#__joresponder_users', $item_data);
					} catch (Exception $e) {
						
					}
				}
			}
		}
	}
}
