<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Methods supporting a list of tracks.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 * @since       1.6
 */
class JoresponderModelTracks extends JModelList
{
	/**
	 * Constructor.
	 *
	 * @param   array  An optional associative array of configuration settings.
	 * @see     JController
	 * @since   1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'track_date', 'a.track_date',
			);
		}

		parent::__construct($config);
	}

	/**
	 * @since   1.6
	 */
	protected $basename;

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$begin = $this->getUserStateFromRequest($this->context . '.filter.begin', 'filter_begin', '', 'string');
		$this->setState('filter.begin', $begin);

		$end = $this->getUserStateFromRequest($this->context . '.filter.end', 'filter_end', '', 'string');
		$this->setState('filter.end', $end);

		// Load the parameters.
		$params = JComponentHelper::getParams('com_joresponder');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('b.name', 'asc');
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return  JDatabaseQuery
	 * @since   1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select( 'a.*' );
		$query->from($db->quoteName('#__joresponder_tracks') . ' AS a');

		// Join with the banners
		$query->join('LEFT', $db->quoteName('#__joresponder_messages') . ' as b ON b.id=a.email_id')
			->select('b.name as email_title');

		// Join with the client
		$query->join('LEFT', $db->quoteName('#__joresponder_users') . ' as au ON au.id=a.user_id')
			->select('au.name as user_name, au.email as user_email');

		// Filter by begin date
		$begin = $this->getState('filter.begin');
		if (!empty($begin))
		{
			$query->where('a.track_date >= ' . $db->quote($begin));
		}

		// Filter by end date
		$end = $this->getState('filter.end');
		if (!empty($end))
		{
			$query->where('a.track_date <= ' . $db->quote($end));
		}

		// Add the list ordering clause.
		$orderCol = $this->getState('list.ordering', 'track_date');
		$query->order($db->escape($orderCol) . ' ' . $db->escape($this->getState('list.direction', 'ASC')));

		return $query;
	}

	/**
	 * Method to delete rows.
	 *
	 * @param   array  An array of item ids.
	 *
	 * @return  boolean  Returns true on success, false on failure.
	 */
	public function delete()
	{
		$user = JFactory::getUser();
		
		// Delete tracks from this banner
		$db = $this->getDbo();
		$query = $db->getQuery(true)
			->delete($db->quoteName('#__joresponder_tracks'));

		// Filter by begin date
		$begin = $this->getState('filter.begin');
		if (!empty($begin))
		{
			$query->where('track_date >= ' . $db->quote($begin));
		}

		// Filter by end date
		$end = $this->getState('filter.end');
		if (!empty($end))
		{
			$query->where('track_date <= ' . $db->quote($end));
		}
		$db->setQuery($query);
		$this->setError((string) $query);

		try
		{
			$db->execute();
		}
		catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());
			return false;
		}
		

		return true;
	}
}
