<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * Item model.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 * @since       1.6
 */
class JoresponderModelUser extends JModelAdmin
{
	/**
	 * @var    string  The prefix to use with controller messages.
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_JORESPONDER_ITEMS';

	/**
	 * Returns a JTable object, always creating it.
	 *
	 * @param   string  $type    The table type to instantiate. [optional]
	 * @param   string  $prefix  A prefix for the table class name. [optional]
	 * @param   array   $config  Configuration array for model. [optional]
	 *
	 * @return  JTable  A database object
	 *
	 * @since   1.6
	 */
	public function getTable($type = 'Users', $prefix = 'JoresponderTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	
	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form. [optional]
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not. [optional]
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since   1.6
	 */
	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_joresponder.user', 'user', array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
		{
			return false;
		}

		// Modify the form based on access controls.
		if (!$this->canEditState((object) $data))
		{
			// Disable fields for display.
			$form->setFieldAttribute('ordering', 'disabled', 'true');
			$form->setFieldAttribute('state', 'disabled', 'true');

			// Disable fields while saving.
			// The controller has already verified this is a record you can edit.
			$form->setFieldAttribute('ordering', 'filter', 'unset');
			$form->setFieldAttribute('state', 'filter', 'unset');
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 *
	 * @since   1.6
	 */
	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_joresponder.edit.user.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}

		return $data;
	}
	/**
	 * A protected method to get a set of ordering conditions.
	 *
	 * @param   JTable  $table  A record object.
	 *
	 * @return  array  An array of conditions to add to add to ordering queries.
	 *
	 * @since   1.6
	 */
	protected function getReorderConditions($table)
	{
		$condition = array();
		$condition[] = 'state >= 0';
		return $condition;
	}
	
	/**
	 * Method to save the form data.
	 *
	 * @param   array  The form data.
	 *
	 * @return  boolean  True on success.
	 * @since   1.6
	 */
	public function save($data)
	{
		$app = JFactory::getApplication();
		$db  	=  JFactory::getDBO();
		
		if (parent::save($data)) // send emails to this new user
		{
			if($data['id']==0) // only send emails for new user
			{
				$cparams = JComponentHelper::getParams('com_joresponder');
			
				$email_sender = $cparams->get('email_sender', '');
				$redirect_url = $cparams->get('redirect_url', 'index.php');
				$optin = $cparams->get('optin', 0);
				$subscribe_notify = $cparams->get('subscribe_notify', 1);
				$unsubscribe_notify = $cparams->get('unsubscribe_notify', 1);
				$code = substr(md5($data['email'].microtime()),0,8);
				$uid = $this->getState('user.id');
				
				// update this user with the new confirmation code
				$user_data = new stdClass();
				$user_data->id = $uid;
				$user_data->state = ($optin) ? 0 : 1;
				$user_data->code = $code;
				$user_data->ip = $_SERVER['REMOTE_ADDR'];
				
				try { 
					$result = $db->updateObject('#__joresponder_users', $user_data, 'id');
				} catch (Exception $e) {
					// catch the error.
				}
				
				if($optin)
				{
					// send confirmation email
					$url=JURI::root()."index.php?option=com_joresponder&task=confirm&code=$code&id=$uid";
					
					$subject="Please confirm your email";
					$message="Please click on the link below or copy and paste it in the browser address bar:<br><br>".
					'<a href="'.$url.'">'.$url.'</a>';		
					
					$this->_send_mail($email_sender, $data['email'], $subject, $message);
				}
				else {
					$this->_send_welcome_mail($uid);
	
					// notify admin?
					if($subscribe_notify==1) {
						$this->_subscribe_notify($uid);
					}
				}
			}
			
			return true;
		}

		return false;
	}
	
	/* sends the first welcome mail to newly registered or imported user
	if such has been scheduled. Scheduling of those mails is done by setting "0" for "days" */
	/* sends the first welcome mail to newly registered or imported user
	if such has been scheduled. Scheduling of those mails is done by setting "0" for "days" */
	private function _get_welcome_mail()
	{
		$db  	=  JFactory::getDBO();
		
		// first check if this email is already registered
		$query = 'SELECT *'
			. ' FROM #__joresponder_messages'
			. ' WHERE send_after_days = 0';
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$welcome_mail = $db->loadObject();
		return $welcome_mail;
	}
	
	private function _send_welcome_mail($uid)
	{
		$db  	=  JFactory::getDBO();
		
		// select member
		$query = 'SELECT *'
			. ' FROM #__joresponder_users'
			. ' WHERE id = '.(int)$uid
			. ' AND state = 1'
			;
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$member = $db->loadObject();
		
		if(empty($member)) return false;
		
		$mail = $this->_get_welcome_mail();
		if(empty($mail)) return false;
		
		$this->_customize_welcome_email($mail,$member);
	}
	
	/* private function called to customize an email message and send it */
	private function _customize_welcome_email($mail,$member)
	{
		$cparams = JComponentHelper::getParams('com_joresponder');
		$email_sender = $cparams->get('email_sender', '');
		
		// send mail to member
		$subject=$mail->name;				
		$message=$mail->text;
		
		$subject=str_replace("{{name}}",$member->name,$subject);
		$subject=str_replace("{{email}}",$member->email,$subject);
		
		$message=str_replace("{{name}}",$member->name,$message);
		$message=str_replace("{{email}}",$member->email,$message);

		// add unsubscribe link
		$unsub_url = JURI::root()."index.php?option=com_joresponder&task=unsubscribe&email=".urlencode($member->email);
		$message.="<br><br>
		To unsubscribe from our list visit the url below:<br>
		<a href='$unsub_url'>$unsub_url</a>";
		$message=str_replace("\t","",$message);
		
		$this->_send_mail($email_sender,$member->email,$subject,$message);
		
		// record this date time
		$db  	=  JFactory::getDBO();
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = $dtnow->format('Y-m-d H:i:s', true);
		
		$data = new stdClass();
		$data->user_id = $member->id;
		$data->email_id = $mail->id;
		$data->track_date = $now;
		 
		try {
			$result = $db->insertObject('#__joresponder_tracks', $data);
		} catch (Exception $e) {
		}
	}
	// send notice when someone subscribes
	private function _subscribe_notify($mid)
	{
		$db  	=  JFactory::getDBO();
		$cparams = JComponentHelper::getParams('com_joresponder');
		$email_sender = $cparams->get('email_sender', '');
		
		$query = 'SELECT *'
			. ' FROM #__joresponder_users'
			. ' WHERE id = '.(int)$mid
			;
		
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$member = $db->loadObject();
		
		$subject = "New user subscribed to the mailing list";
		$message = 'User details:'."<br><p>".'Name:'.' '.$member->name.
			'</p><p>'.'Email:'.' '.$member->email;
		
		$this->_send_mail("",$email_sender,$subject,$message);
	}
	/* wrapper for joomla mail function */
	private function _send_mail($from="",$to,$subject,$message)
	{
		$db  	=  JFactory::getDBO();
		$mail = JFactory::getMailer();
		$jconfig = new JConfig();
		$MailFrom = $jconfig->mailfrom;
		$FromName = $jconfig->fromname;
		
		if($from!="") {
			$mail->setSender($from);
		}
		else {
			$mail->setSender(array($MailFrom, $FromName));
		}
		
		$mail->setSubject($subject);
		$mail->setBody($message);
		$mail->IsHTML(true);
		$mail->addRecipient($to);
	
		$sent = $mail->Send();
	}
}
