<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_joresponder
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * View class for a list of tracks.
 */
class JoresponderViewForm extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		JoresponderHelper::addSubmenu('form');

		$this->addToolbar();

		// Include the component HTML helpers.
		JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

		$this->sidebar = JHtmlSidebar::render();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar()
	{
		require_once JPATH_COMPONENT . '/helpers/joresponder.php';

		$canDo = JoresponderHelper::getActions();

		JToolbarHelper::title(JText::_('COM_JORESPONDER_MANAGER_TRACKS'), 'banners-tracks.png');

		$bar = JToolBar::getInstance('toolbar');
		
		$document = JFactory::getDocument();
		$app = JFactory::getApplication();
		if ($canDo->get('core.delete'))
		{
			$bar->appendButton('Confirm', 'COM_JORESPONDER_DELETE_MSG', 'delete', 'COM_JORESPONDER_TRACKS_DELETE', 'tracks.delete', false);
			JToolbarHelper::divider();
		}
		if ($canDo->get('core.admin'))
		{
			JToolbarHelper::preferences('com_joresponder');
		}
	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 *
	 * @since   3.0
	 */
	protected function getSortFields()
	{
		return array();
	}
}
