<?php
/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

JLoader::register('JoresponderHelper', JPATH_COMPONENT.'/helpers/joresponder.php');

/**
 * View to edit an message.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_joresponder
 * @since		1.5
 */
class JoresponderViewMessage extends JViewLegacy
{
	protected $form;
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		// Initialiase variables.
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');
		$this->state	= $this->get('State');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);

		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$isNew		= ($this->item->id == 0);
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
		// Since we don't track these assets at the item level, use the category id.
		$canDo		= JoresponderHelper::getActions($this->item->id,0);

		JToolBarHelper::title($isNew ? JText::_('COM_JORESPONDER_MANAGER_MESSAGE_NEW') : JText::_('COM_JORESPONDER_MANAGER_MESSAGE_EDIT'), 'itemedit');

		// If not checked out, can save the item.
		if (!$checkedOut && ($canDo->get('core.edit') || count($user->getAuthorisedCategories('com_joresponder', 'core.create')) > 0)) {
			JToolBarHelper::apply('message.apply');
			JToolBarHelper::save('message.save');

			if ($canDo->get('core.create')) {
				JToolBarHelper::save2new('message.save2new');
			}
		}

		// If an existing message, can save to a copy.
		if (!$isNew && $canDo->get('core.create')) {
			JToolBarHelper::save2copy('message.save2copy');
		}

		if (empty($this->item->id))  {
			JToolBarHelper::cancel('message.cancel');
		}
		else {
			JToolBarHelper::cancel('message.cancel', 'JTOOLBAR_CLOSE');
		}
	}
}
