<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_banners
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('behavior.modal', 'a.modal');
JHtml::_('formbehavior.chosen', 'select');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$sortFields = $this->getSortFields();
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>
<form action="<?php echo JRoute::_('index.php?option=com_joresponder&view=tracks'); ?>" method="post" name="adminForm" id="adminForm">
<?php if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="span2">
      <?php echo $this->sidebar; ?>
    </div>  
    <div id="j-main-container" class="span10">
  <?php else : ?>
    <div id="j-main-container">
  <?php endif;?>
  	<div id="filter-bar" class="btn-toolbar">
  		<div class="filter-search btn-group pull-left">
  			<label class="filter-hide-lbl" for="filter_begin"><?php echo JText::_('COM_JORESPONDER_BEGIN_LABEL'); ?></label>
  			<?php echo JHtml::_('calendar', $this->state->get('filter.begin'), 'filter_begin', 'filter_begin', '%Y-%m-%d', array('size' => 10, 'onchange' => "this.form.fireEvent('submit');this.form.submit()"));?>
  		</div>
  		<div class="filter-search btn-group pull-left">
  			<label class="filter-hide-lbl" for="filter_end"><?php echo JText::_('COM_JORESPONDER_END_LABEL'); ?></label>
  			<?php echo JHtml::_('calendar', $this->state->get('filter.end'), 'filter_end', 'filter_end', '%Y-%m-%d', array('size' => 10, 'onchange' => "this.form.fireEvent('submit');this.form.submit()"));?>
  		</div>
  		<div class="btn-group pull-right hidden-phone">
  			<label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC');?></label>
  			<?php echo $this->pagination->getLimitBox(); ?>
  		</div>
  	</div>
  	<div class="clearfix"> </div>
  	<table class="table table-striped">
  		<thead>
  			<tr>
  				<th class="title">
  					<?php echo JText::_('COM_JORESPONDER_HEADING_EMAIL');?>
  				</th>
				<th width="20%" class="nowrap">
  					<?php echo JText::_('COM_JORESPONDER_FIELD_USER_NAME_LABEL');?>
  				</th>
  				<th width="20%" class="nowrap">
  					<?php echo JText::_('COM_JORESPONDER_FIELD_USER_EMAIL_LABEL');?>
  				</th>
  				<th width="10%" class="nowrap hidden-phone">
  					<?php echo JText::_('JDATE');?>
  				</th>
  			</tr>
  		</thead>
  		<tfoot>
  			<tr>
  				<td colspan="6">
  					<?php echo $this->pagination->getListFooter(); ?>
  				</td>
  			</tr>
  		</tfoot>
  		<tbody>
  		<?php foreach ($this->items as $i => $item) :?>
  			<tr class="row<?php echo $i % 2; ?>">
  				<td>
  					<?php echo $item->email_title;?>
  				</td>
  				<td>
  					<?php echo $item->user_name;?>
  				</td>
				<td>
  					<?php echo $item->user_email;?>
  				</td>
  				<td class="hidden-phone">
  					<?php echo JHtml::_('date', $item->track_date, JText::_('DATE_FORMAT_LC4').' H:i');?>
  				</td>
  			</tr>
  		<?php endforeach; ?>
  		</tbody>
  	</table>
  
  	<input type="hidden" name="task" value="" />
  	<input type="hidden" name="boxchecked" value="0" />
  	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
  	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
  	<?php echo JHtml::_('form.token'); ?>
	</div>
</form>
