function mobilesim_init(width) {
    return function () {
        $$('#sbox-content iframe')[0].addEvent('load', function () {
            var d = this.contentDocument,
                css = d.createElement('style');
            css.innerText = 'html{scrollbar-width:thin}'
                + ' ::-webkit-scrollbar{width:4px;background-color:#fff}'
                + ' ::-webkit-scrollbar-thumb{box-shadow:inset 0 0 4px #666}'
                + ' body,body.ui-mobile-viewport>.ui-page{width:' + width + 'px;overflow-x:hidden}';
            d.body.appendChild(css);
        });
    }
}

function mobilesim_cleanup(device) {
    return function () {
        $('sbox-window').removeClass(device);
        var l = $$('#sbox-content iframe')[0].contentWindow.location.href.replace(/device=[^&#]*/, 'device=');
        try {
            new Request({url: l}).send();
        } catch (e) {
            new Ajax(l).request();
        }
    }
}

function update_preview_cookie() {
    var wait = 20*60*1000,
        now = new Date();
    now.setTime(now.getTime() + wait);
    document.cookie = 'mjpreview=1; expires=' + now.toGMTString() + '; path=/';
    setTimeout(update_preview_cookie, wait/2);
}
update_preview_cookie();
