<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.47
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2020 Kuneri Ltd. / Denis Ryabov
 * @date       May 2020
 */
defined('_JEXEC') or die('Restricted access');

abstract class MjBaseController
{
    /** @var string */
    public $name = '';

    /** @var string */
    public $action = 'display';

    /** @var MjJoomlaWrapper */
    protected $joomlaWrapper;

    /**
     * @param MjJoomlaWrapper $joomlaWrapper
     */
    public function __construct($joomlaWrapper)
    {
        $this->joomlaWrapper = $joomlaWrapper;
    }

    public function execute($action)
    {
        $this->action = $action;
        if (!method_exists($this, $action)) {
            $this->joomlaWrapper->raiseWarning('Action is not found');
            return false;
        }
        return $this->$action();
    }

    public function display()
    {
        $viewName = $this->joomlaWrapper->getRequestWord('view', 'default');

        echo $this->renderView($viewName);
    }

    public function save($msg = '')
    {
        if ($this->action === 'save') {
            $redirectUrl = 'index.php?option=com_mobilejoomla';
        } else {
            $controllerName = $this->name;
            $viewName = $this->joomlaWrapper->getRequestWord('view', 'default');
            $redirectUrl = 'index.php?option=com_mobilejoomla&controller=' . $controllerName . '&view=' . $viewName;
        }

        $app = JFactory::getApplication();
        $app->enqueueMessage($msg);
        $app->redirect($redirectUrl);
    }

    public function apply()
    {
        $this->save();
    }

    public function cancel()
    {
        $app = JFactory::getApplication();
        $app->redirect('index.php?option=com_mobilejoomla');
    }

    /**
     * @param string $viewName
     * @param array $params
     * @return null|string
     */
    protected function renderView($viewName, $params = array())
    {
        include_once JPATH_COMPONENT . '/classes/array_unshift_assoc.php';
        include_once JPATH_COMPONENT . '/classes/mjhtml.php';

        /* @todo: move events to wrapper */
        JPluginHelper::importPlugin('mobile');
        $dispatcher = JDispatcher::getInstance();
        $dispatcher->trigger('onMJRenderView', array($viewName, &$params));

        if (strpos($viewName, '/') !== false) {
            list($controllerName, $viewName) = explode('/', $viewName, 2);
        } else {
            $controllerName = $this->name;
        }

        $filename = JPATH_COMPONENT . '/views/' . $controllerName . '/' . $viewName . '.php';
        if (!is_file($filename)) {
            $this->joomlaWrapper->raiseWarning('View is not found');
            return null;
        }

        ob_start();
        $this->requireFile($filename, $params, $controllerName, $viewName);
        return ob_get_clean();
    }

    private function requireFile($filepath, $params, $controllerName, $viewName)
    {
        return include $filepath;
    }
}